// moment.js language configuration
// language : Georgian (ka)
// author : Irakli Janiashvili : https://github.com/irakli-janiashvili

function monthsCaseReplace(m, format) {
    var months = {
        'nominative': 'იანვარი_თებერვალი_მარტი_აპრილი_მაისი_ივნისი_ივლისი_აგვისტო_სექტემბერი_ოქტომბერი_ნოემბერი_დეკემბერი'.split('_'),
        'accusative': 'იანვარს_თებერვალს_მარტს_აპრილის_მაისს_ივნისს_ივლისს_აგვისტს_სექტემბერს_ოქტომბერს_ნოემბერს_დეკემბერს'.split('_')
    },

    nounCase = (/D[oD] *MMMM?/).test(format) ?
        'accusative' :
        'nominative';

    return months[nounCase][m.month()];
}

function weekdaysCaseReplace(m, format) {
    var weekdays = {
        'nominative': 'კვირა_ორშაბათი_სამშაბათი_ოთხშაბათი_ხუთშაბათი_პარასკევი_შაბათი'.split('_'),
        'accusative': 'კვირას_ორშაბათს_სამშაბათს_ოთხშაბათს_ხუთშაბათს_პარასკევს_შაბათს'.split('_')
    },

    nounCase = (/(წინა|შემდეგ)/).test(format) ?
        'accusative' :
        'nominative';

    return weekdays[nounCase][m.day()];
}

require('../moment').lang('ka', {
    months : monthsCaseReplace,
    monthsShort : "იან_თებ_მარ_აპრ_მაი_ივნ_ივლ_აგვ_სექ_ოქტ_ნოე_დეკ".split("_"),
    weekdays : weekdaysCaseReplace,
    weekdaysShort : "კვი_ორშ_სამ_ოთხ_ხუთ_პარ_შაბ".split("_"),
    weekdaysMin : "კვ_ორ_სა_ოთ_ხუ_პა_შა".split("_"),
    longDateFormat : {
        LT : "h:mm A",
        L : "DD/MM/YYYY",
        LL : "D MMMM YYYY",
        LLL : "D MMMM YYYY LT",
        LLLL : "dddd, D MMMM YYYY LT"
    },
    calendar : {
        sameDay : '[დღეს] LT[-ზე]',
        nextDay : '[ხვალ] LT[-ზე]',
        lastDay : '[გუშინ] LT[-ზე]',
        nextWeek : '[შემდეგ] dddd LT[-ზე]',
        lastWeek : '[წინა] dddd LT-ზე',
        sameElse : 'L'
    },
    relativeTime : {
        future : function (s) {
            return (/(წამი|წუთი|საათი|წელი)/).test(s) ?
                s.replace(/ი$/, "ში") :
                s + "ში";
        },
        past : function (s) {
            if ((/(წამი|წუთი|საათი|დღე|თვე)/).test(s)) {
                return s.replace(/(ი|ე)$/, "ის წინ");
            }
            if ((/წელი/).test(s)) {
                return s.replace(/წელი$/, "წლის წინ");
            }
        },
        s : "რამდენიმე წამი",
        m : "წუთი",
        mm : "%d წუთი",
        h : "საათი",
        hh : "%d საათი",
        d : "დღე",
        dd : "%d დღე",
        M : "თვე",
        MM : "%d თვე",
        y : "წელი",
        yy : "%d წელი"
    },
    ordinal : function (number) {
        if (number === 0) {
            return number;
        }

        if (number === 1) {
            return number + "-ლი";
        }

        if ((number < 20) || (number <= 100 && (number % 20 === 0)) || (number % 100 === 0)) {
            return "მე-" + number;
        }

        return number + "-ე";
    },
    week : {
        dow : 1,
        doy : 7
    }
});
