var tape = require('tape')
var through = require('through2')
var pumpify = require('./')
var stream = require('stream')

tape('basic', function(t) {
  t.plan(3)

  var pipeline = pumpify(
    through(function(data, enc, cb) {
      t.same(data.toString(), 'hello')
      cb(null, data.toString().toUpperCase())
    }),
    through(function(data, enc, cb) {
      t.same(data.toString(), 'HELLO')
      cb(null, data.toString().toLowerCase())
    })
  )

  pipeline.write('hello')
  pipeline.on('data', function(data) {
    t.same(data.toString(), 'hello')
    t.end()
  })
})

tape('3 times', function(t) {
  t.plan(4)

  var pipeline = pumpify(
    through(function(data, enc, cb) {
      t.same(data.toString(), 'hello')
      cb(null, data.toString().toUpperCase())
    }),
    through(function(data, enc, cb) {
      t.same(data.toString(), 'HELLO')
      cb(null, data.toString().toLowerCase())
    }),
    through(function(data, enc, cb) {
      t.same(data.toString(), 'hello')
      cb(null, data.toString().toUpperCase())
    })
  )

  pipeline.write('hello')
  pipeline.on('data', function(data) {
    t.same(data.toString(), 'HELLO')
    t.end()
  })
})

tape('destroy', function(t) {
  var test = through()
  test.destroy = function() {
    t.ok(true)
    t.end()
  }

  var pipeline = pumpify(through(), test)

  pipeline.destroy()
})

tape('close', function(t) {
  var test = through()
  var pipeline = pumpify(through(), test)

  pipeline.on('error', function(err) {
    t.same(err.message, 'lol')
    t.end()
  })

  test.emit('error', new Error('lol'))
})

tape('end waits for last one', function(t) {
  var ran = false

  var a = through()
  var b = through()
  var c = through(function(data, enc, cb) {
    setTimeout(function() {
      ran = true
      cb()
    }, 100)
  })

  var pipeline = pumpify(a, b, c)

  pipeline.write('foo')
  pipeline.end(function() {
    t.ok(ran)
    t.end()
  })

  t.ok(!ran)
})

tape('always wait for finish', function(t) {
  var a = new stream.Readable()
  a._read = function() {}
  a.push('hello')

  var pipeline = pumpify(a, through(), through())
  var ran = false

  pipeline.on('finish', function() {
    t.ok(ran)
    t.end()
  })

  setTimeout(function() {
    ran = true
    a.push(null)
  }, 100)
})

tape('async', function(t) {
  var pipeline = pumpify()

  t.plan(4)

  pipeline.write('hello')
  pipeline.on('data', function(data) {
    t.same(data.toString(), 'HELLO')
    t.end()
  })

  setTimeout(function() {
    pipeline.setPipeline(
      through(function(data, enc, cb) {
        t.same(data.toString(), 'hello')
        cb(null, data.toString().toUpperCase())
      }),
      through(function(data, enc, cb) {
        t.same(data.toString(), 'HELLO')
        cb(null, data.toString().toLowerCase())
      }),
      through(function(data, enc, cb) {
        t.same(data.toString(), 'hello')
        cb(null, data.toString().toUpperCase())
      })
    )
  }, 100)
})

tape('early destroy', function(t) {
  var a = through()
  var b = through()
  var c = through()

  b.destroy = function() {
    t.ok(true)
    t.end()
  }

  var pipeline = pumpify()

  pipeline.destroy()
  setTimeout(function() {
    pipeline.setPipeline(a, b, c)
  }, 100)
})