// Generated by LiveScript 1.3.1
var LiveScript, path, fs, util, prelude, each, breakList, ref$, parseOptions, generateHelp, nameFromPath, version, say, warn, die, p, pp, ppp, o, positional, e, toInsert, that, filename, slice$ = [].slice;
LiveScript = require('..');
path = require('path');
fs = require('fs');
util = require('util');
prelude = require('prelude-ls'), each = prelude.each, breakList = prelude.breakList;
ref$ = require('./options'), parseOptions = ref$.parse, generateHelp = ref$.generateHelp;
nameFromPath = require('./util').nameFromPath;
version = LiveScript.VERSION;
say = console.log;
warn = console.error;
die = function(message){
  console.error(message);
  process.exit(1);
};
p = function(){
  var args;
  args = slice$.call(arguments);
  each(console.dir, args);
};
pp = function(x, showHidden, depth){
  say(util.inspect(x, showHidden, depth, !process.env.NODE_DISABLE_COLORS));
};
ppp = function(it){
  pp(it, true, null);
};
try {
  o = parseOptions(process.argv);
  positional = o._;
} catch (e$) {
  e = e$;
  console.error(e.message);
  process.exit(1);
}
switch (false) {
case !o.nodejs:
  forkNode();
  break;
case !o.version:
  say("LiveScript version " + version);
  break;
case !o.help:
  say(generateHelp({
    interpolate: {
      version: version
    }
  }));
  break;
default:
  o.run = !(o.compile || (o.compile = o.output));
  process.execPath = process.argv[0] = process.argv[1];
  toInsert = o.stdin
    ? positional
    : o.run
      ? positional.splice(1, 9e9)
      : [];
  (ref$ = process.argv).splice.apply(ref$, [2, 9e9].concat(slice$.call(toInsert)));
  if (that = o.require) {
    filename = module.filename;
    module.filename = '.';
    each(function(it){
      return global[nameFromPath(it)] = require(it);
    })(
    that);
    module.filename = filename;
  }
  switch (false) {
  case !o.eval:
    compileScript('', o.eval);
    break;
  case !o.stdin:
    compileStdin();
    break;
  case !positional.length:
    compileScripts();
    break;
  case !require('tty').isatty(0):
    say("LiveScript " + version + " - use 'lsc --help' for more information");
    repl();
    break;
  default:
    compileStdin();
  }
}
function fshoot(name, arg, callback){
  fs[name](arg, function(e, result){
    if (e) {
      die(e.stack || e);
    }
    callback(result);
  });
}
function compileScripts(){
  positional.forEach(function(it){
    walk(it, path.normalize(it), true);
  });
  function walk(source, base, top){
    function work(){
      fshoot('readFile', source, function(it){
        compileScript(source, it + "", base);
      });
    }
    fs.stat(source, function(e, stats){
      if (e) {
        if (!top || /(?:\.ls|\/)$/.test(source)) {
          die("Can't find: " + source);
        }
        walk(source + ".ls", base);
        return;
      }
      if (stats.isDirectory()) {
        if (!o.run) {
          fshoot('readdir', source, function(it){
            it.forEach(function(it){
              walk(source + "/" + it, base);
            });
          });
          return;
        }
        source += '/index.ls';
      }
      if (top || '.ls' === source.slice(-3)) {
        if (o.watch) {
          watch(source, work);
        } else {
          work();
        }
      }
    });
  }
}
function compileScript(filename, input, base){
  var options, t, json, e;
  options = {
    filename: filename,
    bare: o.bare,
    'const': o['const']
  };
  t = {
    input: input,
    options: options
  };
  try {
    LiveScript.emit('lex', t);
    t.tokens = LiveScript.tokens(t.input, {
      raw: o.lex
    });
    if (o.lex || o.tokens) {
      printTokens(t.tokens);
      throw null;
    }
    LiveScript.emit('parse', t);
    t.ast = LiveScript.ast(t.tokens);
    json = o.json || /\.json\.ls$/.test(filename);
    if (o.ast) {
      say(json
        ? t.ast.stringify(2)
        : ''.trim.call(t.ast));
      throw null;
    }
    LiveScript.emit('compile', t);
    options.bare || (options.bare = json || o.run);
    if (json || o.run && o.print) {
      t.ast.makeReturn();
    }
    t.output = t.ast.compileRoot(options);
    if (o.compile && o.header) {
      t.output = "// Generated by LiveScript " + version + "\n" + t.output;
    }
    if (json || o.run) {
      LiveScript.emit('run', t);
      t.result = LiveScript.run(t.output, options, true);
    }
    if (json) {
      t.output = JSON.stringify(t.result, null, 2) + '\n';
    }
    if (o.run) {
      switch (false) {
      case !json:
        process.stdout.write(t.output);
        break;
      case !o.print:
        console.log(t.result);
      }
      throw null;
    }
    LiveScript.emit('write', t);
    if (o.print || !filename) {
      say(t.output.trimRight());
    } else {
      writeJS(filename, t.output, base, json);
    }
  } catch (e$) {
    e = e$;
    if (e != null) {
      if (LiveScript.listeners('failure').length) {
        LiveScript.emit('failure', e, t);
      } else {
        if (filename) {
          warn("Failed at: " + filename);
        }
        if (!(e instanceof SyntaxError || /^Parse error /.test(e.message))) {
          e = e.stack || e;
        }
        if (o.watch) {
          warn(e + '\x07');
        } else {
          die(e);
        }
      }
      return;
    }
  }
  LiveScript.emit('success', t);
}
function compileStdin(){
  var x$, code;
  x$ = process.openStdin();
  code = '';
  x$.on('data', function(it){
    code += it;
  });
  x$.on('end', function(){
    compileScript('', code);
  });
  x$.on('data', function(){
    var ref$;
    if ((ref$ = code.slice(-3)) === '\x04\r\n' || ref$ === '\x1a\r\n') {
      compileScript('', code.slice(0, -3));
      x$.destroy();
    }
  });
}
function watch(source, action){
  (function repeat(ptime){
    fshoot('stat', source, function(arg$){
      var mtime;
      mtime = arg$.mtime;
      if (ptime ^ mtime) {
        action();
      }
      setTimeout(repeat, 500, mtime);
    });
  }.call(this, 0));
}
function writeJS(source, js, base, json){
  var filename, dir, that, jsPath;
  filename = path.basename(source).replace(/(?:(\.\w+)?\.\w+)?$/, function(){
    return arguments[1] || (json ? '.json' : '.js');
  });
  dir = path.dirname(source);
  if (that = o.output) {
    dir = path.join(that, dir.slice(base === '.'
      ? 0
      : base.length));
  }
  jsPath = path.join(dir, filename);
  function compile(){
    fs.writeFile(jsPath, js || '\n', function(e){
      if (e) {
        return warn(e);
      }
      if (o.watch) {
        util.log(source + " => " + jsPath);
      }
    });
  }
  fs.stat(dir, function(e){
    if (!e) {
      return compile();
    }
    require('child_process').exec("mkdir " + [!/^win/.test(process.platform) ? '-p' : void 8] + " " + dir, compile);
  });
}
function printTokens(tokens){
  var lines, i$, len$, ref$, tag, val, lno, l;
  lines = [];
  for (i$ = 0, len$ = tokens.length; i$ < len$; ++i$) {
    ref$ = tokens[i$], tag = ref$[0], val = ref$[1], lno = ref$[2];
    ((ref$ = lines[lno]) != null
      ? ref$
      : lines[lno] = []).push(tag.toLowerCase() === val
      ? tag
      : tag + ":" + val);
  }
  for (i$ = 0, len$ = lines.length; i$ < len$; ++i$) {
    l = lines[i$];
    say(l ? l.join(' ').replace(/\n/g, '\\n') : '');
  }
}
function repl(){
  var code, cont, rl, reset, _ttyWrite, prompt, that, vm, replCtx, server, ref$;
  code = repl.infunc ? '  ' : '';
  cont = 0;
  rl = require('readline').createInterface(process.stdin, process.stdout);
  reset = function(){
    rl.line = code = '';
    rl.prompt();
    repl.inheredoc = false;
  };
  (_ttyWrite = rl._ttyWrite, rl)._ttyWrite = function(char){
    if (char === '\n' || char === '>') {
      cont += 1;
    } else {
      cont = 0;
    }
    return _ttyWrite.apply(this, arguments);
  };
  prompt = 'ls';
  if (that = repeatString$('b', !!o.bare) + repeatString$('c', !!o.compile)) {
    prompt += " -" + that;
  }
  if (LiveScript != null) {
    LiveScript.history = rl.history;
  }
  if (!o.compile) {
    module.paths = module.constructor._nodeModulePaths(module.filename = process.cwd() + '/repl');
    vm = require('vm');
    if (o.prelude) {
      import$(global, prelude);
    }
    replCtx = {};
    import$(replCtx, global);
    replCtx.module = module;
    replCtx.exports = exports;
    replCtx.require = require;
    replCtx.LiveScript = LiveScript;
    replCtx.path = path;
    replCtx.fs = fs;
    replCtx.util = util;
    replCtx.say = say;
    replCtx.warn = warn;
    replCtx.die = die;
    replCtx.p = p;
    replCtx.pp = pp;
    replCtx.ppp = ppp;
    server = (ref$ = clone$(require('repl').REPLServer.prototype), ref$.context = replCtx, ref$.commands = [], ref$.useGlobal = false, ref$.useColors = process.env.NODE_DISABLE_COLORS, ref$.eval = function(code, ctx, arg$, cb){
      var res, e;
      try {
        res = vm.runInNewContext(code, ctx, 'repl');
      } catch (e$) {
        e = e$;
      }
      cb(e, res);
    }, ref$);
    rl.completer = bind$(server, 'complete');
  }
  rl.on('SIGCONT', rl.prompt);
  rl.on('SIGINT', function(){
    if (this.line || code) {
      say('');
      reset();
    } else {
      this.close();
    }
  });
  rl.on('close', function(){
    say('');
    return process.exit();
  });
  rl.on('line', function(it){
    var isheredoc, ops, x, e;
    if (it.match(/^$/)) {
      repl.infunc = false;
    }
    if (it.match(/(\=|\~>|->|do|import|switch)\s*$/) || (it.match(/^!?(function|class|if|unless) /) && !it.match(/ then /))) {
      repl.infunc = true;
    }
    if (((0 < cont && cont < 3) || repl.infunc) && !repl.inheredoc) {
      code += it + '\n';
      this.output.write(repeatString$('.', prompt.length) + '. ');
      return;
    } else {
      isheredoc = it.match(/(\'\'\'|\"\"\")/g);
      if (isheredoc && isheredoc.length % 2 === 1) {
        repl.inheredoc = !repl.inheredoc;
      }
      if (repl.inheredoc) {
        code += it + '\n';
        rl.output.write(repeatString$('.', prompt.length) + '" ');
        return;
      }
    }
    repl.inheredoc = false;
    if (!(code += it)) {
      return reset();
    }
    try {
      if (o.compile) {
        say(LiveScript.compile(code, {
          bare: o.bare
        }));
      } else {
        ops = {
          'eval': 'eval',
          bare: true,
          saveScope: LiveScript
        };
        if (code.match(/^\s*!?function/)) {
          ops = {
            bare: true
          };
        }
        x = vm.runInNewContext(LiveScript.compile(code, ops), replCtx, 'repl');
        if (x != null) {
          replCtx._ = x;
        }
        pp(x);
        if (typeof x === 'function') {
          say(x);
        }
      }
    } catch (e$) {
      e = e$;
      say(e);
    }
    reset();
  });
  process.on('uncaughtException', function(it){
    say("\n" + ((it != null ? it.stack : void 8) || it));
  });
  process.on('exit', function(){
    if (code && rl.output.isTTY) {
      rl._ttyWrite('\r');
    }
  });
  rl.setPrompt(prompt + "> ");
  rl.prompt();
}
function forkNode(){
  var ref$, args, lsArgs, ref1$, nodeArgs;
  ref$ = process.argv, args = slice$.call(ref$, 1);
  ref$ = breakList((function(it){
    return it === '--nodejs' || it === '-n';
  }), args), lsArgs = ref$[0], ref1$ = ref$[1], nodeArgs = slice$.call(ref1$, 1);
  require('child_process').spawn(process.execPath, nodeArgs.concat(lsArgs), {
    cwd: process.cwd(),
    customFds: [0, 1, 2]
  });
}
function repeatString$(str, n){
  for (var r = ''; n > 0; (n >>= 1) && (str += str)) if (n & 1) r += str;
  return r;
}
function import$(obj, src){
  var own = {}.hasOwnProperty;
  for (var key in src) if (own.call(src, key)) obj[key] = src[key];
  return obj;
}
function clone$(it){
  function fun(){} fun.prototype = it;
  return new fun;
}
function bind$(obj, key, target){
  return function(){ return (target || obj)[key].apply(obj, arguments) };
}