'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var CRUD_NEXT_PAGE = exports.CRUD_NEXT_PAGE = 'CRUD_NEXT_PAGE';

var nextPage = exports.nextPage = function nextPage(resource) {
    return {
        type: CRUD_NEXT_PAGE,
        meta: { resource: resource }
    };
};

var CRUD_PREV_PAGE = exports.CRUD_PREV_PAGE = 'CRUD_PREV_PAGE';

var prevPage = exports.prevPage = function prevPage(resource) {
    return {
        type: CRUD_PREV_PAGE,
        meta: { resource: resource }
    };
};

var CRUD_GOTO_PAGE = exports.CRUD_GOTO_PAGE = 'CRUD_GOTO_PAGE';

var gotoPage = exports.gotoPage = function gotoPage(resource, page) {
    return {
        type: CRUD_GOTO_PAGE,
        payload: { page: page },
        meta: { resource: resource }
    };
};