'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _defineProperty2 = require('babel-runtime/helpers/defineProperty');

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _extends3 = require('babel-runtime/helpers/extends');

var _extends4 = _interopRequireDefault(_extends3);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRedux = require('react-redux');

var _Card = require('material-ui/Card');

var _Toolbar = require('material-ui/Toolbar');

var _inflection = require('inflection');

var _inflection2 = _interopRequireDefault(_inflection);

var _InputList = require('./InputList');

var _InputList2 = _interopRequireDefault(_InputList);

var _Title = require('../layout/Title');

var _Title2 = _interopRequireDefault(_Title);

var _ListButton = require('../button/ListButton');

var _ListButton2 = _interopRequireDefault(_ListButton);

var _SaveButton = require('../button/SaveButton');

var _SaveButton2 = _interopRequireDefault(_SaveButton);

var _dataActions = require('../../actions/dataActions');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var Create = function (_Component) {
    (0, _inherits3.default)(Create, _Component);

    function Create(props) {
        (0, _classCallCheck3.default)(this, Create);

        var _this = (0, _possibleConstructorReturn3.default)(this, (Create.__proto__ || Object.getPrototypeOf(Create)).call(this, props));

        _this.state = { record: {} };
        _this.handleSubmit = _this.handleSubmit.bind(_this);
        _this.handleChange = _this.handleChange.bind(_this);
        return _this;
    }

    (0, _createClass3.default)(Create, [{
        key: 'getBasePath',
        value: function getBasePath() {
            var location = this.props.location;

            return location.pathname.split('/').slice(0, -1).join('/');
        }
    }, {
        key: 'handleChange',
        value: function handleChange(key, value) {
            this.setState({ record: (0, _extends4.default)({}, this.state.record, (0, _defineProperty3.default)({}, key, value)) });
        }
    }, {
        key: 'handleSubmit',
        value: function handleSubmit(event) {
            event.preventDefault();
            this.props.crudCreate(this.props.resource, this.state.record, this.getBasePath());
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props;
            var title = _props.title;
            var children = _props.children;
            var data = _props.data;
            var isLoading = _props.isLoading;
            var resource = _props.resource;

            var basePath = this.getBasePath();
            return _react2.default.createElement(
                _Card.Card,
                { style: { margin: '2em', opacity: isLoading ? .8 : 1 } },
                _react2.default.createElement(
                    _Card.CardActions,
                    { style: { zIndex: 2, display: 'inline-block', float: 'right' } },
                    _react2.default.createElement(_ListButton2.default, { basePath: basePath })
                ),
                _react2.default.createElement(_Card.CardTitle, { title: _react2.default.createElement(_Title2.default, { title: title, record: data, defaultTitle: 'Create ' + _inflection2.default.humanize(_inflection2.default.singularize(resource)) }) }),
                _react2.default.createElement(
                    'form',
                    { onSubmit: this.handleSubmit },
                    _react2.default.createElement(
                        'div',
                        { style: { padding: '0 1em 1em 1em' } },
                        _react2.default.createElement(_InputList2.default, { record: this.state.record, inputs: children, resource: resource, handleChange: this.handleChange, basePath: basePath })
                    ),
                    _react2.default.createElement(
                        _Toolbar.Toolbar,
                        null,
                        _react2.default.createElement(
                            _Toolbar.ToolbarGroup,
                            null,
                            _react2.default.createElement(_SaveButton2.default, null)
                        )
                    )
                )
            );
        }
    }]);
    return Create;
}(_react.Component);

Create.propTypes = {
    title: _react.PropTypes.any,
    resource: _react.PropTypes.string.isRequired,
    location: _react.PropTypes.object.isRequired,
    params: _react.PropTypes.object.isRequired,
    isLoading: _react.PropTypes.bool.isRequired,
    crudCreate: _react.PropTypes.func.isRequired
};

function mapStateToProps(state) {
    return {
        isLoading: state.admin.loading > 0
    };
}

exports.default = (0, _reactRedux.connect)(mapStateToProps, { crudCreate: _dataActions.crudCreate })(Create);
module.exports = exports['default'];