'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _defineProperty2 = require('babel-runtime/helpers/defineProperty');

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _extends3 = require('babel-runtime/helpers/extends');

var _extends4 = _interopRequireDefault(_extends3);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRedux = require('react-redux');

var _Card = require('material-ui/Card');

var _Toolbar = require('material-ui/Toolbar');

var _inflection = require('inflection');

var _inflection2 = _interopRequireDefault(_inflection);

var _InputList = require('./InputList');

var _InputList2 = _interopRequireDefault(_InputList);

var _Title = require('../layout/Title');

var _Title2 = _interopRequireDefault(_Title);

var _button = require('../button');

var _dataActions = require('../../actions/dataActions');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var Edit = function (_Component) {
    (0, _inherits3.default)(Edit, _Component);

    function Edit(props) {
        (0, _classCallCheck3.default)(this, Edit);

        var _this = (0, _possibleConstructorReturn3.default)(this, (Edit.__proto__ || Object.getPrototypeOf(Edit)).call(this, props));

        _this.state = { record: props.data };
        _this.handleSubmit = _this.handleSubmit.bind(_this);
        _this.handleChange = _this.handleChange.bind(_this);
        return _this;
    }

    (0, _createClass3.default)(Edit, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            this.props.crudGetOne(this.props.resource, this.props.id, this.getBasePath());
        }
    }, {
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            if (this.props.data !== nextProps.data) {
                this.setState({ record: nextProps.data }); // FIXME: erases user entry when fetch response arrives late
            }
            if (this.props.id !== nextProps.id) {
                this.props.crudGetOne(nextProps.resource, nextProps.id, this.getBasePath());
            }
        }

        // FIXME Seems that the cloneElement in CrudRoute slices the children array, which makes this necessary to avoid rerenders

    }, {
        key: 'shouldComponentUpdate',
        value: function shouldComponentUpdate(nextProps) {
            var _this2 = this;

            return nextProps.isLoading !== this.props.isLoading || nextProps.children.every(function (child, index) {
                return child === _this2.props.children[index];
            });
        }
    }, {
        key: 'getBasePath',
        value: function getBasePath() {
            var location = this.props.location;

            return location.pathname.split('/').slice(0, -1).join('/');
        }
    }, {
        key: 'handleChange',
        value: function handleChange(key, value) {
            this.setState({ record: (0, _extends4.default)({}, this.state.record, (0, _defineProperty3.default)({}, key, value)) });
        }
    }, {
        key: 'handleSubmit',
        value: function handleSubmit(event) {
            event.preventDefault();
            this.props.crudUpdate(this.props.resource, this.props.id, this.state.record, this.getBasePath());
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props;
            var title = _props.title;
            var children = _props.children;
            var id = _props.id;
            var data = _props.data;
            var isLoading = _props.isLoading;
            var resource = _props.resource;
            var hasDelete = _props.hasDelete;

            var basePath = this.getBasePath();
            return _react2.default.createElement(
                _Card.Card,
                { style: { margin: '2em', opacity: isLoading ? .8 : 1 } },
                _react2.default.createElement(
                    _Card.CardActions,
                    { style: { zIndex: 2, display: 'inline-block', float: 'right' } },
                    _react2.default.createElement(_button.ListButton, { basePath: basePath }),
                    hasDelete && _react2.default.createElement(_button.DeleteButton, { basePath: basePath, record: data })
                ),
                _react2.default.createElement(_Card.CardTitle, { title: _react2.default.createElement(_Title2.default, { title: title, record: data, defaultTitle: _inflection2.default.humanize(_inflection2.default.singularize(resource)) + ' #' + id }) }),
                _react2.default.createElement(
                    'form',
                    { onSubmit: this.handleSubmit },
                    _react2.default.createElement(
                        'div',
                        { style: { padding: '0 1em 1em 1em' } },
                        _react2.default.createElement(_InputList2.default, { record: this.state.record, inputs: children, resource: resource, handleChange: this.handleChange, basePath: basePath })
                    ),
                    _react2.default.createElement(
                        _Toolbar.Toolbar,
                        null,
                        _react2.default.createElement(
                            _Toolbar.ToolbarGroup,
                            null,
                            _react2.default.createElement(_button.SaveButton, null)
                        )
                    )
                )
            );
        }
    }]);
    return Edit;
}(_react.Component);

Edit.propTypes = {
    title: _react.PropTypes.any,
    id: _react.PropTypes.string.isRequired,
    resource: _react.PropTypes.string.isRequired,
    location: _react.PropTypes.object.isRequired,
    hasDelete: _react.PropTypes.bool.isRequired,
    params: _react.PropTypes.object.isRequired,
    data: _react.PropTypes.object,
    isLoading: _react.PropTypes.bool.isRequired,
    crudGetOne: _react.PropTypes.func.isRequired,
    crudUpdate: _react.PropTypes.func.isRequired
};

function mapStateToProps(state, props) {
    return {
        id: props.params.id,
        data: state.admin[props.resource].data[props.params.id],
        isLoading: state.admin.loading > 0
    };
}

exports.default = (0, _reactRedux.connect)(mapStateToProps, { crudGetOne: _dataActions.crudGetOne, crudUpdate: _dataActions.crudUpdate })(Edit);
module.exports = exports['default'];