'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Labeled = require('../input/Labeled');

var _Labeled2 = _interopRequireDefault(_Labeled);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var InputList = function InputList(_ref) {
    var record = _ref.record;
    var inputs = _ref.inputs;
    var resource = _ref.resource;
    var handleChange = _ref.handleChange;
    var basePath = _ref.basePath;
    return _react2.default.createElement(
        'div',
        null,
        record ? _react2.default.Children.map(inputs, function (input) {
            return _react2.default.createElement(
                'div',
                { key: input.props.source },
                input.props.includesLabel ? _react2.default.cloneElement(input, {
                    resource: resource,
                    record: record,
                    onChange: handleChange,
                    basePath: basePath
                }) : _react2.default.createElement(
                    _Labeled2.default,
                    {
                        label: input.props.label,
                        resource: resource,
                        record: record,
                        onChange: handleChange,
                        basePath: basePath
                    },
                    input
                )
            );
        }) : null
    );
};

exports.default = InputList;
module.exports = exports['default'];