'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _DatePicker = require('material-ui/DatePicker');

var _DatePicker2 = _interopRequireDefault(_DatePicker);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DateInput = function (_Component) {
    (0, _inherits3.default)(DateInput, _Component);

    function DateInput() {
        (0, _classCallCheck3.default)(this, DateInput);
        return (0, _possibleConstructorReturn3.default)(this, (DateInput.__proto__ || Object.getPrototypeOf(DateInput)).apply(this, arguments));
    }

    (0, _createClass3.default)(DateInput, [{
        key: 'handleChange',
        value: function handleChange(event, date) {
            this.props.onChange(this.props.source, date.toISOString());
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props;
            var source = _props.source;
            var label = _props.label;
            var record = _props.record;
            var locale = _props.locale;
            var options = _props.options;

            var date = null;
            if (record[source] instanceof Date) {
                date = record[source];
            } else if (record[source]) {
                date = new Date(record[source]);
            }
            return _react2.default.createElement(_DatePicker2.default, (0, _extends3.default)({
                floatingLabelText: label,
                locale: locale,
                DateTimeFormat: Intl.DateTimeFormat,
                value: date,
                onChange: this.handleChange.bind(this),
                container: 'inline',
                autoOk: true
            }, options));
        }
    }]);
    return DateInput;
}(_react.Component);

DateInput.propTypes = {
    source: _react.PropTypes.string.isRequired,
    label: _react.PropTypes.string,
    record: _react.PropTypes.object,
    locale: _react.PropTypes.string.isRequired,
    options: _react.PropTypes.object,
    onChange: _react.PropTypes.func,
    includesLabel: _react.PropTypes.bool.isRequired
};

DateInput.defaultProps = {
    record: {},
    options: {},
    locale: 'en-US',
    includesLabel: true
};

exports.default = DateInput;
module.exports = exports['default'];