'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _TextField = require('material-ui/TextField');

var _TextField2 = _interopRequireDefault(_TextField);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Use any component as read-only Input, labeled just like other Inputs.
 *
 * Useful to use a Field in the Edit or Create components.
 * The child component will receive the current record.
 *
 * @example
 * <Labeled label="Comments">
 *     <FooComponent source="title" />
 * </Labeled>
 */
var Labeled = function Labeled(_ref) {
    var label = _ref.label;
    var resource = _ref.resource;
    var record = _ref.record;
    var onChange = _ref.onChange;
    var basePath = _ref.basePath;
    var children = _ref.children;
    return _react2.default.createElement(
        _TextField2.default,
        {
            floatingLabelText: label,
            floatingLabelFixed: true,
            disabled: true,
            fullWidth: true,
            underlineShow: false,
            style: { paddingTop: '2em', height: 'auto' }
        },
        _react2.default.cloneElement(children, { record: record, resource: resource, onChange: onChange, basePath: basePath })
    );
};

Labeled.propTypes = {
    label: _react.PropTypes.string.isRequired,
    record: _react.PropTypes.object,
    resource: _react.PropTypes.string,
    basePath: _react.PropTypes.string,
    onChange: _react.PropTypes.func,
    children: _react.PropTypes.element
};

exports.default = Labeled;
module.exports = exports['default'];