'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ReferenceInput = undefined;

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRedux = require('react-redux');

var _Labeled = require('./Labeled');

var _Labeled2 = _interopRequireDefault(_Labeled);

var _dataActions = require('../../actions/dataActions');

var _possibleValues = require('../../reducer/references/possibleValues');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var referenceSource = function referenceSource(resource, source) {
    return resource + '@' + source;
};

var ReferenceInput = exports.ReferenceInput = function (_Component) {
    (0, _inherits3.default)(ReferenceInput, _Component);

    function ReferenceInput() {
        (0, _classCallCheck3.default)(this, ReferenceInput);
        return (0, _possibleConstructorReturn3.default)(this, (ReferenceInput.__proto__ || Object.getPrototypeOf(ReferenceInput)).apply(this, arguments));
    }

    (0, _createClass3.default)(ReferenceInput, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            var _props = this.props;
            var reference = _props.reference;
            var record = _props.record;
            var source = _props.source;
            var resource = _props.resource;

            this.fetchReferenceAndOptions(reference, record[source], referenceSource(resource, source));
        }
    }, {
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            if (this.props.record.id !== nextProps.record.id) {
                var reference = nextProps.reference;
                var record = nextProps.record;
                var source = nextProps.source;
                var resource = nextProps.resource;

                this.fetchReferenceAndOptions(reference, record[source], referenceSource(resource, source));
            }
        }
    }, {
        key: 'fetchReferenceAndOptions',
        value: function fetchReferenceAndOptions(reference, id, relatedTo) {
            if (id) {
                this.props.crudGetOne(reference, id, null, false);
            }
            this.props.crudGetMatching(reference, relatedTo, {});
        }
    }, {
        key: 'handleChange',
        value: function handleChange(event, key, payload) {
            this.props.onChange(this.props.source, payload);
        }
    }, {
        key: 'render',
        value: function render() {
            var _props2 = this.props;
            var resource = _props2.resource;
            var label = _props2.label;
            var source = _props2.source;
            var record = _props2.record;
            var referenceRecord = _props2.referenceRecord;
            var allowEmpty = _props2.allowEmpty;
            var matchingReferences = _props2.matchingReferences;
            var basePath = _props2.basePath;
            var onChange = _props2.onChange;
            var children = _props2.children;

            if (!referenceRecord && !allowEmpty) {
                return _react2.default.createElement(
                    _Labeled2.default,
                    { label: label },
                    _react2.default.createElement(
                        'div',
                        null,
                        ' '
                    )
                );
            }
            return _react2.default.cloneElement(children, {
                label: label,
                resource: resource,
                source: source,
                record: record,
                choices: matchingReferences,
                basePath: basePath,
                onChange: onChange
            });
        }
    }]);
    return ReferenceInput;
}(_react.Component);

ReferenceInput.propTypes = {
    children: _react.PropTypes.element.isRequired,
    resource: _react.PropTypes.string.isRequired,
    source: _react.PropTypes.string.isRequired,
    label: _react.PropTypes.string,
    record: _react.PropTypes.object,
    matchingReferences: _react.PropTypes.array,
    allowEmpty: _react.PropTypes.bool.isRequired,
    reference: _react.PropTypes.string.isRequired,
    referenceRecord: _react.PropTypes.object,
    basePath: _react.PropTypes.string,
    onChange: _react.PropTypes.func,
    crudGetOne: _react.PropTypes.func.isRequired,
    crudGetMatching: _react.PropTypes.func.isRequired,
    includesLabel: _react.PropTypes.bool.isRequired
};

ReferenceInput.defaultProps = {
    referenceRecord: null,
    record: {},
    allowEmpty: false,
    matchingReferences: []
};

function mapStateToProps(state, props) {
    var referenceId = props.record[props.source];
    return {
        referenceRecord: state.admin[props.reference].data[referenceId],
        matchingReferences: (0, _possibleValues.getPossibleReferences)(state, referenceSource(props.resource, props.source), props.reference, referenceId)
    };
}

var ConnectedReferenceInput = (0, _reactRedux.connect)(mapStateToProps, {
    crudGetOne: _dataActions.crudGetOne,
    crudGetMatching: _dataActions.crudGetMatching
})(ReferenceInput);

ConnectedReferenceInput.defaultProps = {
    includesLabel: true
};

exports.default = ConnectedReferenceInput;