'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _SelectField = require('material-ui/SelectField');

var _SelectField2 = _interopRequireDefault(_SelectField);

var _MenuItem = require('material-ui/MenuItem');

var _MenuItem2 = _interopRequireDefault(_MenuItem);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * An Input component for a select box, using an array of objects for the options
 *
 * Pass possible options as an array of objects in the 'choices' attribute.
 *
 * By default, the options are built from:
 *  - the 'id' property as the option value,
 *  - the 'name' property an the option text
 *
 * @example
 * <SelectInput source="gender" choices={[
 *    { id: 'M', name: 'Male' },
 *    { id: 'F', label: 'Female' },
 * ]} />
 *
 * You can also customize the properties to use for the option name and value,
 * thanks to the 'optionText' and 'optionValue' attributes.
 *
 * @example
 * <SelectInput label="Author" source="author_id" optionText="full_name" optionValue="_id" choices={[
 *    { _id: 123, full_name: 'Leo Tolstoi', sex: 'M' },
 *    { _id: 456, full_name: 'Jane Austen', sex: 'F' },
 * ]} />
 */
var SelectInput = function (_Component) {
    (0, _inherits3.default)(SelectInput, _Component);

    function SelectInput() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, SelectInput);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = SelectInput.__proto__ || Object.getPrototypeOf(SelectInput)).call.apply(_ref, [this].concat(args))), _this), _this.handleChange = function (event, key, payload) {
            _this.props.onChange(_this.props.source, payload);
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(SelectInput, [{
        key: 'render',
        value: function render() {
            var _props = this.props;
            var label = _props.label;
            var source = _props.source;
            var record = _props.record;
            var choices = _props.choices;
            var optionText = _props.optionText;
            var optionValue = _props.optionValue;
            var options = _props.options;

            return _react2.default.createElement(
                _SelectField2.default,
                (0, _extends3.default)({
                    menuStyle: { maxHeight: '41px', overflowY: 'hidden' },
                    floatingLabelText: label,
                    value: record[source],
                    onChange: this.handleChange,
                    autoWidth: true
                }, options),
                choices.map(function (choice) {
                    return _react2.default.createElement(_MenuItem2.default, { key: choice[optionText], primaryText: choice[optionText], value: choice[optionValue] });
                })
            );
        }
    }]);
    return SelectInput;
}(_react.Component);

SelectInput.propTypes = {
    label: _react.PropTypes.string,
    source: _react.PropTypes.string,
    record: _react.PropTypes.object,
    choices: _react.PropTypes.arrayOf(_react.PropTypes.object),
    optionText: _react.PropTypes.string.isRequired,
    optionValue: _react.PropTypes.string.isRequired,
    options: _react.PropTypes.object,
    onChange: _react.PropTypes.func,
    includesLabel: _react.PropTypes.bool.isRequired
};

SelectInput.defaultProps = {
    record: {},
    options: {},
    optionText: 'name',
    optionValue: 'id',
    includesLabel: true
};

exports.default = SelectInput;
module.exports = exports['default'];