'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _TextField = require('material-ui/TextField');

var _TextField2 = _interopRequireDefault(_TextField);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var EMPTY_STRING = '';

var TextInput = function (_Component) {
    (0, _inherits3.default)(TextInput, _Component);

    function TextInput() {
        (0, _classCallCheck3.default)(this, TextInput);
        return (0, _possibleConstructorReturn3.default)(this, (TextInput.__proto__ || Object.getPrototypeOf(TextInput)).apply(this, arguments));
    }

    (0, _createClass3.default)(TextInput, [{
        key: 'handleChange',
        value: function handleChange(event) {
            this.props.onChange(this.props.source, event.target.value);
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props;
            var source = _props.source;
            var label = _props.label;
            var record = _props.record;
            var options = _props.options;

            return _react2.default.createElement(_TextField2.default, (0, _extends3.default)({
                name: source,
                floatingLabelText: label,
                value: record[source] || EMPTY_STRING,
                onChange: this.handleChange.bind(this)
            }, options));
        }
    }]);
    return TextInput;
}(_react.Component);

TextInput.propTypes = {
    source: _react.PropTypes.string.isRequired,
    label: _react.PropTypes.string,
    record: _react.PropTypes.object,
    options: _react.PropTypes.object,
    onChange: _react.PropTypes.func,
    includesLabel: _react.PropTypes.bool.isRequired
};

TextInput.defaultProps = {
    record: {},
    options: {},
    includesLabel: true
};

exports.default = TextInput;
module.exports = exports['default'];