'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRedux = require('react-redux');

var _reactRouter = require('react-router');

var _MuiThemeProvider = require('material-ui/styles/MuiThemeProvider');

var _MuiThemeProvider2 = _interopRequireDefault(_MuiThemeProvider);

var _AppBar = require('material-ui/AppBar');

var _AppBar2 = _interopRequireDefault(_AppBar);

var _CircularProgress = require('material-ui/CircularProgress');

var _CircularProgress2 = _interopRequireDefault(_CircularProgress);

var _Notification = require('./Notification');

var _Notification2 = _interopRequireDefault(_Notification);

var _reactTapEventPlugin = require('react-tap-event-plugin');

var _reactTapEventPlugin2 = _interopRequireDefault(_reactTapEventPlugin);

var _Menu = require('./Menu');

var _Menu2 = _interopRequireDefault(_Menu);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _reactTapEventPlugin2.default)();

var Layout = function Layout(_ref) {
    var isLoading = _ref.isLoading;
    var children = _ref.children;
    var route = _ref.route;
    var title = _ref.title;

    var Title = _react2.default.createElement(
        _reactRouter.Link,
        { to: '/', style: { color: '#fff', textDecoration: 'none' } },
        title
    );
    var RightElement = isLoading ? _react2.default.createElement(_CircularProgress2.default, { color: '#fff', size: 0.5 }) : _react2.default.createElement('span', null);

    return _react2.default.createElement(
        _MuiThemeProvider2.default,
        null,
        _react2.default.createElement(
            'div',
            { style: { display: 'flex', flexDirection: 'column', minHeight: '100vh' } },
            _react2.default.createElement(_AppBar2.default, { title: Title, iconElementRight: RightElement }),
            _react2.default.createElement(
                'div',
                { className: 'body', style: { display: 'flex', flex: '1', backgroundColor: '#edecec' } },
                _react2.default.createElement(
                    'div',
                    { style: { flex: 1 } },
                    children
                ),
                _react2.default.createElement(_Menu2.default, { resources: route.resources })
            ),
            _react2.default.createElement(_Notification2.default, null)
        )
    );
};

Layout.propTypes = {
    isLoading: _react.PropTypes.bool.isRequired,
    children: _react.PropTypes.node,
    route: _react.PropTypes.object.isRequired,
    title: _react.PropTypes.string.isRequired
};

function mapStateToProps(state) {
    return { isLoading: state.admin.loading > 0 };
}

exports.default = (0, _reactRedux.connect)(mapStateToProps)(Layout);
module.exports = exports['default'];