'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Table = require('material-ui/Table');

var _FlatButton = require('material-ui/FlatButton');

var _FlatButton2 = _interopRequireDefault(_FlatButton);

var _sort = require('material-ui/svg-icons/content/sort');

var _sort2 = _interopRequireDefault(_sort);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var Datagrid = function Datagrid(_ref) {
    var resource = _ref.resource;
    var children = _ref.children;
    var ids = _ref.ids;
    var data = _ref.data;
    var currentSort = _ref.currentSort;
    var basePath = _ref.basePath;
    var selectable = _ref.selectable;
    var updateSort = _ref.updateSort;
    return _react2.default.createElement(
        _Table.Table,
        { multiSelectable: selectable },
        _react2.default.createElement(
            _Table.TableHeader,
            { adjustForCheckbox: selectable, displaySelectAll: selectable },
            _react2.default.createElement(
                _Table.TableRow,
                null,
                _react2.default.Children.toArray(children).map(function (field) {
                    return _react2.default.createElement(
                        _Table.TableHeaderColumn,
                        { key: field.props.label || 'no-key' },
                        (field.props.label || field.props.source) && _react2.default.createElement(_FlatButton2.default, {
                            labelPosition: 'before',
                            onClick: updateSort,
                            'data-sort': field.props.source,
                            label: field.props.label || field.props.source,
                            icon: field.props.source === currentSort.sort ? _react2.default.createElement(_sort2.default, { style: currentSort.order === 'ASC' ? { transform: 'rotate(180deg)' } : {} }) : false
                        })
                    );
                })
            )
        ),
        _react2.default.createElement(
            _Table.TableBody,
            { showRowHover: true, displayRowCheckbox: selectable },
            ids.map(function (id) {
                return _react2.default.createElement(
                    _Table.TableRow,
                    { key: id },
                    _react2.default.Children.toArray(children).map(function (field) {
                        return _react2.default.createElement(
                            _Table.TableRowColumn,
                            { key: id + '-' + field.props.source },
                            _react2.default.createElement(field.type, (0, _extends3.default)({}, field.props, { record: data[id], basePath: basePath, resource: resource }))
                        );
                    })
                );
            })
        )
    );
};

Datagrid.propTypes = {
    ids: _react.PropTypes.arrayOf(_react.PropTypes.number).isRequired,
    resource: _react.PropTypes.string,
    selectable: _react.PropTypes.bool,
    data: _react.PropTypes.object.isRequired,
    currentSort: _react.PropTypes.shape({
        sort: _react.PropTypes.string,
        order: _react.PropTypes.string
    }),
    basePath: _react.PropTypes.string,
    updateSort: _react.PropTypes.func
};

Datagrid.defaultProps = {
    data: {},
    ids: [],
    selectable: true
};

exports.default = Datagrid;
module.exports = exports['default'];