'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.FilterForm = undefined;

var _defineProperty2 = require('babel-runtime/helpers/defineProperty');

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _extends3 = require('babel-runtime/helpers/extends');

var _extends4 = _interopRequireDefault(_extends3);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Card = require('material-ui/Card');

var _IconButton = require('material-ui/IconButton');

var _IconButton2 = _interopRequireDefault(_IconButton);

var _highlightOff = require('material-ui/svg-icons/action/highlight-off');

var _highlightOff2 = _interopRequireDefault(_highlightOff);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var FilterForm = exports.FilterForm = function (_Component) {
    (0, _inherits3.default)(FilterForm, _Component);

    function FilterForm(props) {
        (0, _classCallCheck3.default)(this, FilterForm);

        var _this = (0, _possibleConstructorReturn3.default)(this, (FilterForm.__proto__ || Object.getPrototypeOf(FilterForm)).call(this, props));

        _this.handleChange = _this.handleChange.bind(_this);
        _this.handleHide = _this.handleHide.bind(_this);
        _this.timer = null;
        _this.state = {
            filterValues: props.filterValues
        };
        return _this;
    }

    (0, _createClass3.default)(FilterForm, [{
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            if (this.props.filterValues !== nextProps.filterValues) {
                this.setState({ filterValues: nextProps.filterValues }); // FIXME: erases user entry when fetch response arrives late
            }
        }
    }, {
        key: 'getShownFilters',
        value: function getShownFilters() {
            var _props = this.props;
            var filters = _props.filters;
            var displayedFilters = _props.displayedFilters;
            var filterValues = _props.filterValues;

            return filters.filter(function (filterElement) {
                return filterElement.props.alwaysOn || displayedFilters[filterElement.props.source] || filterValues[filterElement.props.source];
            });
        }
    }, {
        key: 'handleChange',
        value: function handleChange(key, value) {
            var _this2 = this;

            this.setState({ filterValues: (0, _extends4.default)({}, this.state.filterValues, (0, _defineProperty3.default)({}, key, value)) });
            // poor man's debounce
            if (this.timer) {
                clearTimeout(this.timer);
            }
            this.timer = setTimeout(function () {
                return _this2.props.setFilter(key, value);
            }, 500);
        }
    }, {
        key: 'handleHide',
        value: function handleHide(event) {
            this.props.hideFilter(event.currentTarget.dataset.key);
        }
    }, {
        key: 'render',
        value: function render() {
            var _this3 = this;

            var resource = this.props.resource;

            return _react2.default.createElement(
                'div',
                null,
                _react2.default.createElement(
                    _Card.CardText,
                    { style: { float: 'right', marginTop: '-14px', paddingTop: 0 } },
                    this.getShownFilters().map(function (filterElement) {
                        return _react2.default.createElement(
                            'div',
                            { key: filterElement.props.source },
                            filterElement.props.alwaysOn ? _react2.default.createElement(
                                'div',
                                { style: { width: 48, display: 'inline-block' } },
                                ' '
                            ) : _react2.default.createElement(
                                _IconButton2.default,
                                { iconStyle: { color: '#00bcd4' }, onTouchTap: _this3.handleHide, 'data-key': filterElement.props.source, tooltip: 'Remove this filter' },
                                _react2.default.createElement(_highlightOff2.default, null)
                            ),
                            _react2.default.createElement(filterElement.type, (0, _extends4.default)({}, filterElement.props, {
                                resource: resource,
                                record: _this3.state.filterValues,
                                onChange: _this3.handleChange
                            }))
                        );
                    })
                ),
                _react2.default.createElement('div', { style: { clear: 'right' } })
            );
        }
    }]);
    return FilterForm;
}(_react.Component);

FilterForm.propTypes = {
    resource: _react.PropTypes.string.isRequired,
    filters: _react.PropTypes.arrayOf(_react.PropTypes.node).isRequired,
    displayedFilters: _react.PropTypes.object.isRequired,
    filterValues: _react.PropTypes.object.isRequired,
    hideFilter: _react.PropTypes.func.isRequired,
    setFilter: _react.PropTypes.func.isRequired
};

exports.default = FilterForm;