'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _defineProperty2 = require('babel-runtime/helpers/defineProperty');

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRedux = require('react-redux');

var _reactRouterRedux = require('react-router-redux');

var _Card = require('material-ui/Card');

var _FlatButton = require('material-ui/FlatButton');

var _FlatButton2 = _interopRequireDefault(_FlatButton);

var _refresh = require('material-ui/svg-icons/navigation/refresh');

var _refresh2 = _interopRequireDefault(_refresh);

var _inflection = require('inflection');

var _inflection2 = _interopRequireDefault(_inflection);

var _queryReducer = require('../../reducer/resource/list/queryReducer');

var _queryReducer2 = _interopRequireDefault(_queryReducer);

var _Title = require('../layout/Title');

var _Title2 = _interopRequireDefault(_Title);

var _Pagination = require('./Pagination');

var _Pagination2 = _interopRequireDefault(_Pagination);

var _CreateButton = require('../button/CreateButton');

var _CreateButton2 = _interopRequireDefault(_CreateButton);

var _dataActions = require('../../actions/dataActions');

var _listActions = require('../../actions/listActions');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var List = function (_Component) {
    (0, _inherits3.default)(List, _Component);

    function List(props) {
        (0, _classCallCheck3.default)(this, List);

        var _this = (0, _possibleConstructorReturn3.default)(this, (List.__proto__ || Object.getPrototypeOf(List)).call(this, props));

        _this.state = {};
        _this.updateSort = _this.updateSort.bind(_this);
        _this.setPage = _this.setPage.bind(_this);
        _this.setFilter = _this.setFilter.bind(_this);
        _this.showFilter = _this.showFilter.bind(_this);
        _this.hideFilter = _this.hideFilter.bind(_this);
        return _this;
    }

    (0, _createClass3.default)(List, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            this.updateData();
        }
    }, {
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            if (nextProps.resource !== this.props.resource || nextProps.query.sort !== this.props.query.sort || nextProps.query.order !== this.props.query.order || nextProps.query.page !== this.props.query.page || nextProps.query.filter !== this.props.query.filter) {
                this.updateData(Object.keys(nextProps.query).length > 0 ? nextProps.query : nextProps.params);
            }
        }
    }, {
        key: 'getBasePath',
        value: function getBasePath() {
            return this.props.location.pathname;
        }
    }, {
        key: 'refresh',
        value: function refresh(event) {
            event.stopPropagation();
            this.updateData();
        }
    }, {
        key: 'getQuery',
        value: function getQuery() {
            return Object.keys(this.props.query).length > 0 ? this.props.query : (0, _extends3.default)({}, this.props.params);
        }
    }, {
        key: 'updateData',
        value: function updateData(query) {
            var _ref = query || this.getQuery();

            var sort = _ref.sort;
            var order = _ref.order;
            var page = _ref.page;
            var perPage = _ref.perPage;
            var filter = _ref.filter;

            this.props.crudGetList(this.props.resource, { page: page, perPage: perPage }, { field: sort, order: order }, filter);
        }
    }, {
        key: 'updateSort',
        value: function updateSort(event) {
            event.stopPropagation();
            this.changeParams({ type: _queryReducer.SET_SORT, payload: event.currentTarget.dataset.sort });
        }
    }, {
        key: 'setPage',
        value: function setPage(page) {
            this.changeParams({ type: _queryReducer.SET_PAGE, payload: page });
        }
    }, {
        key: 'setFilter',
        value: function setFilter(field, value) {
            this.changeParams({ type: _queryReducer.SET_FILTER, payload: { field: field, value: value } });
        }
    }, {
        key: 'showFilter',
        value: function showFilter(filterName) {
            this.setState((0, _defineProperty3.default)({}, filterName, true));
        }
    }, {
        key: 'hideFilter',
        value: function hideFilter(filterName) {
            this.setState((0, _defineProperty3.default)({}, filterName, false));
            this.setFilter(filterName);
        }
    }, {
        key: 'changeParams',
        value: function changeParams(action) {
            var newParams = (0, _queryReducer2.default)(this.getQuery(), action);
            this.props.push((0, _extends3.default)({}, this.props.location, { query: (0, _extends3.default)({}, newParams, { filter: JSON.stringify(newParams.filter) }) }));
            this.props.changeListParams(this.props.resource, newParams);
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props;
            var filter = _props.filter;
            var resource = _props.resource;
            var hasCreate = _props.hasCreate;
            var title = _props.title;
            var data = _props.data;
            var ids = _props.ids;
            var total = _props.total;
            var children = _props.children;
            var isLoading = _props.isLoading;

            var query = this.getQuery();
            var filterValues = query.filter;
            var basePath = this.getBasePath();
            return _react2.default.createElement(
                _Card.Card,
                { style: { margin: '2em', opacity: isLoading ? .8 : 1 } },
                _react2.default.createElement(
                    _Card.CardActions,
                    { style: { zIndex: 2, display: 'inline-block', float: 'right' } },
                    filter && _react2.default.createElement(filter, {
                        resource: resource,
                        showFilter: this.showFilter,
                        displayedFilters: this.state,
                        filterValues: filterValues,
                        context: 'button'
                    }),
                    hasCreate && _react2.default.createElement(_CreateButton2.default, { basePath: basePath }),
                    _react2.default.createElement(_FlatButton2.default, { primary: true, label: 'Refresh', onClick: this.refresh.bind(this), icon: _react2.default.createElement(_refresh2.default, null) })
                ),
                _react2.default.createElement(_Card.CardTitle, { title: _react2.default.createElement(_Title2.default, { title: title, defaultTitle: _inflection2.default.humanize(_inflection2.default.pluralize(resource)) + ' List' }) }),
                filter && _react2.default.createElement(filter, {
                    resource: resource,
                    hideFilter: this.hideFilter,
                    setFilter: this.setFilter,
                    filterValues: filterValues,
                    displayedFilters: this.state,
                    context: 'form'
                }),
                _react2.default.cloneElement(children, {
                    resource: resource,
                    ids: ids,
                    data: data,
                    currentSort: query,
                    basePath: basePath,
                    updateSort: this.updateSort
                }),
                _react2.default.createElement(_Pagination2.default, { resource: resource, page: parseInt(query.page, 10), perPage: parseInt(query.perPage, 10), total: total, setPage: this.setPage })
            );
        }
    }]);
    return List;
}(_react.Component);

List.propTypes = {
    title: _react.PropTypes.any,
    filter: _react.PropTypes.oneOfType([_react.PropTypes.func, _react.PropTypes.string]),
    resource: _react.PropTypes.string.isRequired,
    hasCreate: _react.PropTypes.bool.isRequired,
    hasEdit: _react.PropTypes.bool.isRequired,
    location: _react.PropTypes.object.isRequired,
    path: _react.PropTypes.string,
    params: _react.PropTypes.object.isRequired,
    query: _react.PropTypes.object.isRequired,
    ids: _react.PropTypes.array,
    total: _react.PropTypes.number.isRequired,
    data: _react.PropTypes.object,
    isLoading: _react.PropTypes.bool.isRequired,
    crudGetList: _react.PropTypes.func.isRequired,
    changeListParams: _react.PropTypes.func.isRequired,
    children: _react.PropTypes.element.isRequired,
    push: _react.PropTypes.func.isRequired
};

function mapStateToProps(state, props) {
    var resourceState = state.admin[props.resource];
    var query = props.location.query;
    if (query.filter && typeof query.filter === 'string') {
        query.filter = JSON.parse(query.filter);
    }
    return {
        query: query,
        params: resourceState.list.params,
        ids: resourceState.list.ids,
        total: resourceState.list.total,
        data: resourceState.data,
        isLoading: state.admin.loading > 0
    };
}

exports.default = (0, _reactRedux.connect)(mapStateToProps, {
    crudGetList: _dataActions.crudGetList,
    changeListParams: _listActions.changeListParams,
    push: _reactRouterRedux.push
})(List);
module.exports = exports['default'];