'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getPossibleReferences = undefined;

var _defineProperty2 = require('babel-runtime/helpers/defineProperty');

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _extends3 = require('babel-runtime/helpers/extends');

var _extends4 = _interopRequireDefault(_extends3);

var _dataActions = require('../../actions/dataActions');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var initialState = {};

exports.default = function () {
    var previousState = arguments.length <= 0 || arguments[0] === undefined ? initialState : arguments[0];
    var _ref = arguments[1];
    var type = _ref.type;
    var payload = _ref.payload;
    var meta = _ref.meta;

    switch (type) {
        case _dataActions.CRUD_GET_MATCHING_SUCCESS:
            return (0, _extends4.default)({}, previousState, (0, _defineProperty3.default)({}, meta.relatedTo, payload.map(function (record) {
                return record.id;
            })));
        default:
            return previousState;
    }
};

var getPossibleReferences = exports.getPossibleReferences = function getPossibleReferences(state, referenceSource, reference, selectedId) {
    if (!state.admin.references.possibleValues[referenceSource]) {
        return typeof selectedId === 'undefined' ? [] : [state.admin[reference].data[selectedId]];
    }
    var possibleValues = state.admin.references.possibleValues[referenceSource];
    if (typeof selectedId !== 'undefined' && !possibleValues.includes(selectedId)) {
        possibleValues.unshift(selectedId);
    }
    return possibleValues.map(function (id) {
        return state.admin[reference].data[id];
    }).filter(function (r) {
        return typeof r !== 'undefined';
    });
};