'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _defineProperty2 = require('babel-runtime/helpers/defineProperty');

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _extends4 = require('babel-runtime/helpers/extends');

var _extends5 = _interopRequireDefault(_extends4);

var _filterActions = require('../../../../actions/filterActions');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var initialState = {
    display: {},
    values: {}
};

exports.default = function (resource) {
    return function () {
        var previousState = arguments.length <= 0 || arguments[0] === undefined ? initialState : arguments[0];
        var _ref = arguments[1];
        var type = _ref.type;
        var payload = _ref.payload;
        var meta = _ref.meta;

        if (!meta || meta.resource !== resource) {
            return previousState;
        }
        switch (type) {
            case _filterActions.CRUD_SHOW_FILTER:
                return {
                    display: (0, _extends5.default)({}, previousState.display, (0, _defineProperty3.default)({}, payload.field, true)),
                    values: previousState.values
                };
            case _filterActions.CRUD_HIDE_FILTER:
                {
                    var values = (0, _extends5.default)({}, previousState.values);
                    delete values[payload.field];
                    return {
                        display: (0, _extends5.default)({}, previousState.display, (0, _defineProperty3.default)({}, payload.field, false)),
                        values: values
                    };
                }
            case _filterActions.CRUD_SET_FILTER:
                {
                    var _values = (0, _extends5.default)({}, previousState.values);
                    if (payload.value) {
                        _values[payload.field] = payload.value;
                    } else {
                        delete _values[payload.field];
                    }
                    return {
                        display: previousState.display,
                        values: _values
                    };
                }
            default:
                return previousState;
        }
    };
};

module.exports = exports['default'];