'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _paginationActions = require('../../../../actions/paginationActions');

var _dataActions = require('../../../../actions/dataActions');

var _sortActions = require('../../../../actions/sortActions');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var initialState = {
    page: 1,
    perPage: 10,
    total: 0
};

exports.default = function (resource) {
    return function () {
        var previousState = arguments.length <= 0 || arguments[0] === undefined ? initialState : arguments[0];
        var _ref = arguments[1];
        var type = _ref.type;
        var payload = _ref.payload;
        var meta = _ref.meta;

        if (!meta || meta.resource !== resource) {
            return previousState;
        }
        var nbPages = Math.ceil(previousState.total / previousState.perPage) || 1;
        switch (type) {
            case _dataActions.CRUD_GET_LIST_SUCCESS:
                return (0, _extends3.default)({}, previousState, { total: payload.total });
            case _sortActions.CRUD_SET_SORT:
                return (0, _extends3.default)({}, previousState, { page: 1 });
            case _paginationActions.CRUD_NEXT_PAGE:
                if (previousState.page === nbPages) {
                    throw new Error('Cannot got to next page: pagination already at last page');
                }
                return (0, _extends3.default)({}, previousState, { page: previousState.page + 1 });
            case _paginationActions.CRUD_PREV_PAGE:
                if (previousState.page === 1) {
                    throw new Error('Cannot got to previous page: pagination already at first page');
                }
                return (0, _extends3.default)({}, previousState, { page: previousState.page - 1 });
            case _paginationActions.CRUD_GOTO_PAGE:
                if (payload.page > nbPages) {
                    throw new Error('Cannot got to a page higher than total (' + previousState.total + ')');
                }
                if (payload.page < 1) {
                    throw new Error('Cannot got to to a page lower than 1');
                }
                return (0, _extends3.default)({}, previousState, { page: parseInt(payload.page, 10) });
            default:
                return previousState;
        }
    };
};

module.exports = exports['default'];