'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _sortActions = require('../../../../actions/sortActions');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var initialState = {
    field: 'id',
    order: _sortActions.SORT_DESC
};

var oppositeOrder = function oppositeOrder(direction) {
    return direction === _sortActions.SORT_DESC ? _sortActions.SORT_ASC : _sortActions.SORT_DESC;
};

exports.default = function (resource) {
    return function () {
        var previousState = arguments.length <= 0 || arguments[0] === undefined ? initialState : arguments[0];
        var _ref = arguments[1];
        var type = _ref.type;
        var payload = _ref.payload;
        var meta = _ref.meta;

        if (!meta || meta.resource !== resource) {
            return previousState;
        }
        switch (type) {
            case _sortActions.CRUD_SET_SORT:
                if (payload.field === previousState.field) {
                    return (0, _extends3.default)({}, previousState, {
                        order: oppositeOrder(previousState.order)
                    });
                }
                return {
                    field: payload.field,
                    order: payload.order
                };
            default:
                return previousState;
        }
    };
};

module.exports = exports['default'];