'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _regenerator = require('babel-runtime/regenerator');

var _regenerator2 = _interopRequireDefault(_regenerator);

var _toConsumableArray2 = require('babel-runtime/helpers/toConsumableArray');

var _toConsumableArray3 = _interopRequireDefault(_toConsumableArray2);

var _reduxSaga = require('redux-saga');

var _effects = require('redux-saga/effects');

var _fetchActions = require('../../actions/fetchActions');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var crudFetch = function crudFetch(restClient) {
    var successSideEffects = arguments.length <= 1 || arguments[1] === undefined ? function () {
        return [];
    } : arguments[1];

    var _marked = [handleFetch].map(_regenerator2.default.mark);

    var failureSideEffects = arguments.length <= 2 || arguments[2] === undefined ? function () {
        return [];
    } : arguments[2];

    function handleFetch(action) {
        var type, payload, meta, restType, response, _sideEffects, sideEffects;

        return _regenerator2.default.wrap(function handleFetch$(_context) {
            while (1) {
                switch (_context.prev = _context.next) {
                    case 0:
                        type = action.type;
                        payload = action.payload;
                        meta = action.meta;
                        restType = meta.fetch;

                        delete meta.fetch;
                        _context.next = 7;
                        return [(0, _effects.put)({ type: type + '_LOADING', payload: payload, meta: meta }), (0, _effects.put)({ type: _fetchActions.FETCH_START })];

                    case 7:
                        response = void 0;
                        _context.prev = 8;
                        _context.next = 11;
                        return (0, _effects.call)(restClient, restType, meta.resource, payload);

                    case 11:
                        response = _context.sent;
                        _context.next = 20;
                        break;

                    case 14:
                        _context.prev = 14;
                        _context.t0 = _context['catch'](8);
                        _sideEffects = failureSideEffects(type, meta.resource, payload, _context.t0);
                        _context.next = 19;
                        return [].concat((0, _toConsumableArray3.default)(_sideEffects.map(function (a) {
                            return (0, _effects.put)(a);
                        })), [(0, _effects.put)({ type: type + '_FAILURE', error: _context.t0.message ? _context.t0.message : _context.t0, meta: meta }), (0, _effects.put)({ type: _fetchActions.FETCH_ERROR })]);

                    case 19:
                        return _context.abrupt('return');

                    case 20:
                        _context.prev = 20;
                        _context.next = 23;
                        return (0, _effects.cancelled)();

                    case 23:
                        if (!_context.sent) {
                            _context.next = 27;
                            break;
                        }

                        _context.next = 26;
                        return (0, _effects.put)({ type: _fetchActions.FETCH_CANCEL });

                    case 26:
                        return _context.abrupt('return');

                    case 27:
                        return _context.finish(20);

                    case 28:
                        sideEffects = successSideEffects(type, meta.resource, payload, response);
                        _context.next = 31;
                        return (0, _effects.put)({ type: _fetchActions.FETCH_END });

                    case 31:
                        _context.next = 33;
                        return [].concat((0, _toConsumableArray3.default)(sideEffects.map(function (a) {
                            return (0, _effects.put)(a);
                        })), [(0, _effects.put)({ type: type + '_SUCCESS', payload: response, meta: meta })]);

                    case 33:
                    case 'end':
                        return _context.stop();
                }
            }
        }, _marked[0], this, [[8, 14, 20, 28]]);
    }

    return _regenerator2.default.mark(function watchCrudFetch() {
        return _regenerator2.default.wrap(function watchCrudFetch$(_context2) {
            while (1) {
                switch (_context2.prev = _context2.next) {
                    case 0:
                        _context2.next = 2;
                        return [(0, _reduxSaga.takeLatest)(function (action) {
                            return action.meta && action.meta.fetch && action.meta.cancelPrevious;
                        }, handleFetch), (0, _reduxSaga.takeEvery)(function (action) {
                            return action.meta && action.meta.fetch && !action.meta.cancelPrevious;
                        }, handleFetch)];

                    case 2:
                    case 'end':
                        return _context2.stop();
                }
            }
        }, watchCrudFetch, this);
    });
};

exports.default = crudFetch;
module.exports = exports['default'];