'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.queryParameters = exports.fetchJson = undefined;

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var fetchJson = exports.fetchJson = function fetchJson(url) {
    var options = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

    var requestHeaders = {
        Accept: 'application/json'
    };
    if (!(options && options.body && options.body instanceof FormData)) {
        requestHeaders['Content-Type'] = 'application/json';
    }
    if (options.user && options.user.authenticated && options.user.authenticated) {
        requestHeaders.Authorization = options.user.token;
    }

    var status = void 0,
        statusText = void 0,
        headers = {},
        body = void 0,
        json = void 0;

    return fetch(url, (0, _extends3.default)({}, options, { headers: requestHeaders, credentials: 'include' })).then(function (response) {
        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
            for (var _iterator = response.headers.entries()[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                var pair = _step.value;

                headers[pair[0]] = pair[1];
            }
        } catch (err) {
            _didIteratorError = true;
            _iteratorError = err;
        } finally {
            try {
                if (!_iteratorNormalCompletion && _iterator.return) {
                    _iterator.return();
                }
            } finally {
                if (_didIteratorError) {
                    throw _iteratorError;
                }
            }
        }

        status = response.status;
        statusText = response.statusText;
        return response;
    }).then(function (response) {
        return response.text();
    }).then(function (text) {
        body = text;
        try {
            json = JSON.parse(text);
        } catch (e) {
            // not json, no big deal
        }
        if (status < 200 || status >= 300) {
            return Promise.reject(new Error(json && json.message || statusText));
        }
        return { status: status, headers: headers, body: body, json: json };
    });
};

var queryParameters = exports.queryParameters = function queryParameters(data) {
    return Object.keys(data).map(function (key) {
        return [key, data[key]].map(encodeURIComponent).join('=');
    }).join('&');
};