'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _regenerator = require('babel-runtime/regenerator');

var _regenerator2 = _interopRequireDefault(_regenerator);

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _effects = require('redux-saga/effects');

var _fetchActions = require('../../actions/fetchActions');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var crudFetch = function crudFetch(restClient) {
    var _marked = [handleFetch].map(_regenerator2.default.mark);

    function handleFetch(action) {
        var type, payload, meta, restType, response;
        return _regenerator2.default.wrap(function handleFetch$(_context) {
            while (1) {
                switch (_context.prev = _context.next) {
                    case 0:
                        type = action.type, payload = action.payload, meta = action.meta;
                        restType = meta.fetch;

                        delete meta.fetch;
                        _context.next = 5;
                        return [(0, _effects.put)({ type: type + '_LOADING', payload: payload, meta: meta }), (0, _effects.put)({ type: _fetchActions.FETCH_START })];

                    case 5:
                        response = void 0;
                        _context.prev = 6;
                        _context.next = 9;
                        return (0, _effects.call)(restClient, restType, meta.resource, payload);

                    case 9:
                        response = _context.sent;
                        _context.next = 12;
                        return (0, _effects.put)({
                            type: type + '_SUCCESS',
                            payload: response,
                            requestPayload: payload,
                            meta: (0, _extends3.default)({}, meta, { fetchResponse: restType, fetchStatus: _fetchActions.FETCH_END })
                        });

                    case 12:
                        _context.next = 14;
                        return (0, _effects.put)({ type: _fetchActions.FETCH_END });

                    case 14:
                        _context.next = 22;
                        break;

                    case 16:
                        _context.prev = 16;
                        _context.t0 = _context['catch'](6);
                        _context.next = 20;
                        return (0, _effects.put)({
                            type: type + '_FAILURE',
                            error: _context.t0.message ? _context.t0.message : _context.t0,
                            requestPayload: payload,
                            meta: (0, _extends3.default)({}, meta, { fetchResponse: restType, fetchStatus: _fetchActions.FETCH_ERROR })
                        });

                    case 20:
                        _context.next = 22;
                        return (0, _effects.put)({ type: _fetchActions.FETCH_ERROR, error: _context.t0 });

                    case 22:
                        _context.prev = 22;
                        _context.next = 25;
                        return (0, _effects.cancelled)();

                    case 25:
                        if (!_context.sent) {
                            _context.next = 29;
                            break;
                        }

                        _context.next = 28;
                        return (0, _effects.put)({ type: _fetchActions.FETCH_CANCEL });

                    case 28:
                        return _context.abrupt('return');

                    case 29:
                        return _context.finish(22);

                    case 30:
                    case 'end':
                        return _context.stop();
                }
            }
        }, _marked[0], this, [[6, 16, 22, 30]]);
    }

    return _regenerator2.default.mark(function watchCrudFetch() {
        return _regenerator2.default.wrap(function watchCrudFetch$(_context2) {
            while (1) {
                switch (_context2.prev = _context2.next) {
                    case 0:
                        _context2.next = 2;
                        return [(0, _effects.takeLatest)(function (action) {
                            return action.meta && action.meta.fetch && action.meta.cancelPrevious;
                        }, handleFetch), (0, _effects.takeEvery)(function (action) {
                            return action.meta && action.meta.fetch && !action.meta.cancelPrevious;
                        }, handleFetch)];

                    case 2:
                    case 'end':
                        return _context2.stop();
                }
            }
        }, watchCrudFetch, this);
    });
};

exports.default = crudFetch;
module.exports = exports['default'];