[slack]: https://aframevr-slack.herokuapp.com
[stackoverflow]: http://stackoverflow.com/questions/tagged/aframe

Interested in contributing? As an open source project, we'd appreciate any help
and contributions! On top of the A-Frame framework itself, you can also
contribute to these related projects:

- [aframe-inspector](https://github.com/aframevr/aframe-inspector)
- [aframe-site](https://github.com/aframevr/aframe-site)

# Join the Community on Slack

1. [Invite yourself][slack] to the A-Frame Slack channel.
2. [Join the discussion](https://aframevr.slack.com)!

# Get Help or Ask a Question

If you're not sure how to do something with A-Frame, please post a question
(and any code you've tried so far) to [Stack Overflow under the 'aframe'
tag][stackoverflow]. Questions there will automatically create notifications in
[Slack][slack], and are easier for others to find so new developers can learn
from your questions too.

# File an Issue

1. Search the [issue tracker](https://github.com/aframevr/aframe/issues) for similar issues.
2. Specify the version of A-Frame in which the bug occurred.
3. Specify information about your browser and system (e.g., "Firefox Nightly on OS X")
4. Describe the problem in detail (i.e., what happened and what you expected would happen).
5. If possible, provide a small test case with [CodePen](http://codepen.io), a link to your application, and/or a screenshot. You can fork this [sample pen](http://codepen.io/anon/pen/KVWpbb).

# Contribute Code to A-Frame

[easy]: https://github.com/aframevr/aframe/labels/help%20wanted%20%28easy%29
[hard]: https://github.com/aframevr/aframe/labels/help%20wanted%20%28hard%29
[testing-guide]: https://github.com/aframevr/aframe/tree/master/tests#a-frame-unit-tests

Check out the [issues labeled *help wanted (easy)*][easy] or [*help wanted
(hard)*][hard] for good issues to tackle.

1. Have a [GitHub account](https://github.com/join).
2. [Fork](https://github.com/aframevr/aframe/fork) the repository on GitHub.
3. Run `npm install` and `npm run dev` to serve the test examples.
4. Make changes to your fork of the repository.
5. If necessary, write [unit tests](tests/) ([guide][testing-guide]) and run with `npm test`.
6. Submit a pull request to the master branch.
7. Address [review comments](http://stackoverflow.com/questions/9790448/how-to-update-a-pull-request) if any.

Please note you would agree to license your contributions under the [license](LICENSE).

# Share your Work

1. Create something awesome like a scene, a component, or a shader.
2. Publish your work to Github (and GitHub pages) so everyone can learn from your work.
3. Share it on [Slack](https://aframevr-slack.herokuapp.com), Twitter, or the [awesome-aframe repository](https://github.com/aframevr/awesome-aframe).
4. Let us know about it so we can feature it on our blog: [A Week of A-Frame](https://aframe.io/blog/).
4. For bonus points, write and publish a case study to explain how you built it.

# Update Documentation

If you catch a typo or error in the documentation, we'd greatly appreciate a
pull request.

1. Go to the bottom of the documentation page on `aframe.io` you wish to update.
2. Click the button to suggest edits on GitHub.
3. Edit the documentation through GitHub's text editor.
4. Prepend the commit message with `[docs]`.
5. We will merge the pull request and cherry-pick it onto documentation
branches for older versions if necessary.

You can also do `npm run docs` within the A-Frame project to start a local live
server for watching and serving documentation.

# Help Your Fellow A-Framers

## On Slack

1. [Invite yourself](https://aframevr-slack.herokuapp.com/) to the A-Frame Slack channel.
2. Help answer questions that people might have and welcome new people.
3. Redirect or cross-post questions to the [Stack Overflow A-Frame tag][stackoverflow].

## On GitHub

1. Help respond to [newly-filed GitHub issues](https://github.com/aframevr/aframe/issues)
2. Redirect developers to [Stack Overflow][stackoverflow] if a question is filed rather than an issue.
3. For extra points, cross-post and answer the question on Stack Overflow after redirecting!

# Curate and Make Efforts Known

Every week, we round up all the cool stuff happening with A-Frame on the
[blog](https://aframe.io/blog). We collect things to show off in [these GitHub
issues](https://github.com/aframevr/aframe-site/labels/A%20Week%20of%20A-Frame).
If you see anything, just post it there!

We also need help keeping the [`awesome-aframe`
repository](https://github.com/aframevr/awesome-aframe) up to date. If you see
any missing content or things that haven't been synced to the blog, make a pull
request there.

# Spread the Word

If you want to hold an event and talk about WebVR and A-Frame, check out [the
presentation kit](https://github.com/aframevr/aframe-presentation-kit).

Thanks so much for contributing and helping grow WebVR!
