# The A-Frame Code of Conduct

Adapted from the [Rust Code of Conduct](https://www.rust-lang.org/en-US/conduct.html).

## Conduct

- We are committed to providing a friendly, safe and welcoming environment for
  all, regardless of level of experience, gender, gender identity and expression,
  sexual orientation, disability, personal appearance, body size, race,
  ethnicity, age, religion, nationality, or other similar characteristic.
- On Slack, please avoid using overtly sexual nicknames or other nicknames that
  might detract from a friendly, safe and welcoming environment for all.
- Please be kind and courteous. There's no need to be mean or rude.
- Respect that people have differences of opinion and that every design or
  implementation choice carries a trade-off and numerous costs. There is seldom
  a right answer.
- Please keep unstructured critique to a minimum. If you have solid ideas you
  want to experiment with, make a fork and see how it works.
- We will exclude you from interaction if you insult, demean or harass anyone.
  That is not welcome behaviour. We interpret the term
  "harassment" as including the definition in the [Citizen Code of
  Conduct](http://citizencodeofconduct.org/); if you have any lack of clarity
  about what might be included in that concept, please read their definition. In
  particular, we don't tolerate behavior that excludes people in socially
  marginalized groups.
- Private harassment is also unacceptable. No matter who you are, if you feel
  you have been or are being harassed or made uncomfortable by a community
  member, please contact one of the channel ops or any of the A-Frame moderation
  team immediately. Whether you're a regular contributor or a newcomer,
  we care about making this community a safe place for you and we've got
  your back.
- Likewise any spamming, trolling, flaming, baiting or other attention-stealing
  behaviour is not welcome.

## Moderation

These are the policies for upholding our community's standards of conduct. If
you feel that a thread needs moderation, please contact one of the A-Frame team
members.

- Remarks that violate the A-Frame standards of conduct, including hateful,
  hurtful, oppressive, or exclusionary remarks, are not allowed. (Cursing is
  allowed, but never targeting another user, and never in a hateful manner.)
- Remarks that moderators find inappropriate, whether listed in the code of
  conduct or not, are also not allowed.
- Moderators will first respond to such remarks with a warning.
- If the warning is unheeded, the user will be kicked, i.e., kicked out of the
  communication channel to cool off.
- If the user comes back and continues to make trouble, they will be banned,
  i.e., indefinitely excluded.
- Moderators may choose at their discretion to un-ban the user if it was a
  first offense and they offer the offended party a genuine apology.
- If a moderator bans someone and you think it was unjustified, please take it
  up with that moderator, or with a different moderator, in private. Complaints
  about bans in-channel are not allowed.
- Moderators are held to a higher standard than other community members. If a
  moderator creates an inappropriate situation, they should expect less leeway
  than others.

The initial and interim moderators will be the developers of A-Frame including,
but not limited to, Diego Marcos <dmarcos@mozilla.com> and Kevin Ngo
<kngo@mozilla.com>. Contact us if you would like to volunteer and be listed as
a moderator.

In the A-Frame community we strive to go the extra step to look out for each
other. Don't just aim to be technically unimpeachable, try to be your best
self. In particular, avoid flirting with offensive or sensitive issues,
particularly if they're off-topic; this all too often leads to unnecessary
fights, hurt feelings, and damaged trust; worse, it can drive people away from
the community entirely.

And if someone takes issue with something you said or did, resist the urge to
be defensive. Just stop doing what it was they complained about and apologize.
Even if you feel you were misinterpreted or unfairly accused, chances are good
there was something you could've communicated better -- remember that it's your
responsibility to make your fellow A-Framers comfortable. Everyone wants to
get along and we are all here first and foremost because we want to talk about
cool technology. You will find that people will be eager to assume good intent
and forgive as long as you earn their trust.

The enforcement policies listed above apply to all official A-Frame venues;
primarily the A-Frame Slack channel and GitHub repositories under aframevr.
For other projects adopting the A-Frame Code of Conduct, please contact the
maintainers of those projects for enforcement. If you wish to use this code of
conduct for your own project, consider explicitly mentioning your moderation
policy or making a copy with your own moderation policy so as to avoid
confusion.
