import type { AgAnnotation, AgAnnotationsThemeableOptions } from 'ag-charts-types';
import type { MementoOriginator } from '../../api/state/memento';
import type { Group } from '../../scene/group';
import type { Node } from '../../scene/node';
import { BaseManager } from '../../util/baseManager';
interface AnnotationsRestoreEvent {
    type: 'restore-annotations';
    annotations: AnnotationsMemento;
}
type AnnotationsMemento = AgAnnotation[];
export declare class AnnotationManager extends BaseManager<AnnotationsRestoreEvent['type'], AnnotationsRestoreEvent> implements MementoOriginator<AnnotationsMemento> {
    private readonly annotationRoot;
    mementoOriginatorKey: "annotations";
    private annotations;
    private styles?;
    constructor(annotationRoot: Group);
    createMemento(): AnnotationsMemento;
    guardMemento(blob: unknown): blob is AnnotationsMemento | undefined;
    restoreMemento(_version: string, _mementoVersion: string, memento: AnnotationsMemento | undefined): void;
    updateData(annotations?: AnnotationsMemento): void;
    attachNode(node: Node): () => this;
    setAnnotationStyles(styles: AgAnnotationsThemeableOptions): void;
    getAnnotationTypeStyles(type: keyof Omit<AgAnnotationsThemeableOptions, 'axesButtons' | 'enabled' | 'optionsToolbar' | 'toolbar'>): import("ag-charts-types").AgFibonacciAnnotationStyles | import("ag-charts-types").AgLineAnnotationStyles | import("ag-charts-types").AgTextAnnotationStyles | import("ag-charts-types").AgCrossLineAnnotationStyles | import("ag-charts-types").AgChannelAnnotationStyles | import("ag-charts-types").AgCalloutAnnotationStyles | import("ag-charts-types").AgCommentAnnotationStyles | import("ag-charts-types").AgNoteAnnotationStyles | import("ag-charts-types").AgShapeAnnotationStyles | import("ag-charts-types").AgMeasurerAnnotationStyles | import("ag-charts-types").AgQuickMeasurerAnnotationStyles | undefined;
    private cleanData;
}
export {};
