import type { AgAxisBoundSeries, AgBaseAxisLabelStyleOptions, CssColor, FontFamily, FontSize, FontStyle, FontWeight } from 'ag-charts-types';
import type { AxisContext } from '../../module/axisContext';
import type { AxisOptionModule } from '../../module/axisOptionModule';
import type { ModuleInstance } from '../../module/baseModule';
import type { ModuleContext, ModuleContextWithParent } from '../../module/moduleContext';
import { ModuleMap } from '../../module/moduleMap';
import type { Scale } from '../../scale/scale';
import { BBox } from '../../scene/bbox';
import { Group, TransformableGroup } from '../../scene/group';
import type { Node } from '../../scene/node';
import { Selection } from '../../scene/selection';
import { Line } from '../../scene/shape/line';
import { TransformableText } from '../../scene/shape/text';
import type { ChartAnimationPhase } from '../chartAnimationPhase';
import type { AxisGroups, ChartAxis, ChartAxisLabel } from '../chartAxis';
import { ChartAxisDirection } from '../chartAxisDirection';
import type { CrossLine } from '../crossline/crossLine';
import type { AnimationManager } from '../interaction/animationManager';
import type { AxisLayout } from '../layout/layoutManager';
import type { ISeries } from '../series/seriesTypes';
import { AxisGridLine } from './axisGridLine';
import { AxisInterval } from './axisInterval';
import { AxisLine } from './axisLine';
import { AxisTick, type TickInterval } from './axisTick';
import { AxisTitle } from './axisTitle';
import type { AxisLineDatum } from './axisUtil';
export interface TickDatum {
    tickLabel: string;
    tick: any;
    tickId: string;
    translationY: number;
    tickSize?: number;
    tickStroke?: string;
    tickWidth?: number;
}
export interface LabelNodeDatum {
    tickId: string;
    fill?: CssColor;
    fontFamily?: FontFamily;
    fontSize?: FontSize;
    fontStyle?: FontStyle;
    fontWeight?: FontWeight;
    rotation: number;
    rotationCenterX: number;
    text: string;
    textAlign?: CanvasTextAlign;
    textBaseline: CanvasTextBaseline;
    visible: boolean;
    x: number;
    y: number;
    translationX?: number;
    translationY: number;
    range: number[];
}
type AxisModuleMap = ModuleMap<AxisOptionModule, ModuleInstance, ModuleContextWithParent<AxisContext>>;
declare const TranslatableLine_base: new (...args: any[]) => import("../../scene/transformable").TranslatableType<Line>;
declare class TranslatableLine extends TranslatableLine_base {
}
/**
 * A general purpose linear axis with no notion of orientation.
 * The axis is always rendered vertically, with horizontal labels positioned to the left
 * of the axis line by default. The axis can be {@link rotation | rotated} by an arbitrary angle,
 * so that it can be used as a top, right, bottom, left, radial or any other kind
 * of linear axis.
 * The generic `D` parameter is the type of the domain of the axis' scale.
 * The output range of the axis' scale is always numeric (screen coordinates).
 */
export declare abstract class Axis<S extends Scale<D, number, TickInterval<S>> = Scale<any, number, any>, D = any> implements ChartAxis {
    protected readonly moduleCtx: ModuleContext;
    readonly scale: S;
    static readonly defaultTickMinSpacing = 50;
    protected static CrossLineConstructor: new () => CrossLine<any>;
    readonly id: string;
    nice: boolean;
    /** Reverse the axis scale domain. */
    reverse: boolean;
    keys: string[];
    readonly interval: AxisInterval<unknown>;
    dataDomain: {
        domain: D[];
        clipped: boolean;
    };
    get type(): string;
    abstract get direction(): ChartAxisDirection;
    layoutConstraints: ChartAxis['layoutConstraints'];
    boundSeries: ISeries<unknown, unknown>[];
    includeInvisibleDomains: boolean;
    interactionEnabled: boolean;
    readonly axisGroup: TransformableGroup;
    protected readonly tickLineGroup: Group;
    protected readonly lineNode: TranslatableLine;
    protected readonly tickLabelGroup: Group;
    protected readonly labelGroup: Group;
    readonly gridGroup: TransformableGroup;
    protected readonly gridLineGroup: Group;
    protected readonly crossLineRangeGroup: TransformableGroup;
    protected readonly crossLineLineGroup: TransformableGroup;
    protected readonly crossLineLabelGroup: TransformableGroup;
    protected tickLineGroupSelection: Selection<TranslatableLine, any>;
    protected tickLabelGroupSelection: Selection<TransformableText, LabelNodeDatum>;
    protected gridLineGroupSelection: Selection<TranslatableLine, any>;
    private _crossLines;
    set crossLines(value: CrossLine[]);
    get crossLines(): CrossLine[];
    readonly line: AxisLine;
    readonly tick: AxisTick;
    readonly gridLine: AxisGridLine;
    readonly label: ChartAxisLabel;
    private readonly tempText;
    private readonly tempCaption;
    protected defaultTickMinSpacing: number;
    readonly translation: {
        x: number;
        y: number;
    };
    rotation: number;
    protected readonly layout: Pick<AxisLayout, 'label'>;
    protected axisContext?: AxisContext;
    protected animationManager: AnimationManager;
    private readonly animationState;
    private readonly destroyFns;
    constructor(moduleCtx: ModuleContext, scale: S);
    resetAnimation(phase: ChartAnimationPhase): void;
    private attachCrossLine;
    private detachCrossLine;
    destroy(): void;
    protected updateRange(): void;
    setCrossLinesVisible(visible: boolean): void;
    attachAxis(groups: AxisGroups): void;
    detachAxis(groups: AxisGroups): void;
    attachLabel(axisLabelNode: Node): void;
    range: [number, number];
    visibleRange: [number, number];
    /**
     * Checks if a point or an object is in range.
     * @param value A point (or object's starting point).
     * @param tolerance Expands the range on both ends by this amount.
     */
    inRange(value: number, tolerance?: number): boolean;
    protected datumFormatter?: (datum: any) => string;
    protected labelFormatter?: (datum: any) => string;
    protected onFormatChange(ticks: any[], fractionDigits: number, _domain: any[], format?: string): void;
    readonly title: AxisTitle;
    /**
     * The length of the grid. The grid is only visible in case of a non-zero value.
     */
    gridLength: number;
    /**
     * The distance between the grid ticks and the axis ticks.
     */
    gridPadding: number;
    /**
     * Is used to avoid collisions between axis labels and series.
     */
    seriesAreaPadding: number;
    protected onGridLengthChange(value: number, prevValue: number): void;
    protected onGridVisibilityChange(): void;
    protected createLabel(): ChartAxisLabel;
    /**
     * Creates/removes/updates the scene graph nodes that constitute the axis.
     */
    update(animated?: boolean): void;
    private getAxisLineCoordinates;
    private getTickLineCoordinates;
    protected getLabelStyles(params: {
        value: string;
        depth?: number;
    }, additionalStyles?: AgBaseAxisLabelStyleOptions): {
        fill: string | undefined;
        fontFamily: string | undefined;
        fontSize: number | undefined;
        fontStyle: FontStyle | undefined;
        fontWeight: FontWeight | undefined;
        spacing: number | undefined;
    };
    private getTickLabelProps;
    protected getTickSize(): number;
    private setTitleProps;
    private tickGenerationResult;
    private _domainCalculated;
    processData(): void;
    calculateLayout(domain?: any[], primaryTickCount?: number): {
        primaryTickCount: number | undefined;
        bbox: BBox;
    };
    private processTicks;
    private updateLayoutState;
    protected getTransformBox(bbox: BBox): BBox;
    setDomain(domain: D[]): void;
    updateScale(opts?: {
        domain?: any[];
        skipDomainCalculation?: boolean;
    }): void;
    private calculateRotations;
    private generateTicks;
    private getTickStrategies;
    private createTickData;
    private getTicks;
    private filterTicks;
    private createTicks;
    private estimateTickCount;
    protected updateCrossLines(): void;
    protected updateTickLines(): void;
    protected calculateAvailableRange(): number;
    /**
     * Calculates the available range with an additional "bleed" beyond the canvas that encompasses the full axis when
     * the visible range is only a portion of the axis.
     */
    protected calculateRangeWithBleed(): number;
    protected calculateDomain(): void;
    protected getAxisTransform(): {
        rotation: number;
        translationX: number;
        translationY: number;
    };
    protected updatePosition(): void;
    protected updateSecondaryAxisTicks(_primaryTickCount: number | undefined): any[];
    protected updateSelections(lineData: AxisLineDatum, data: TickDatum[], params: {
        combinedRotation: number;
        textBaseline: CanvasTextBaseline;
        textAlign: CanvasTextAlign;
        range: number[];
    }): void;
    protected updateGridLines(): void;
    protected updateLabels(): void;
    protected updateTitle(noVisibleTicks?: boolean, spacing?: number): void;
    protected formatTick(value: any, index: number, fractionDigits?: number): string;
    formatDatum(value: any): string;
    private getScaleValueFormatter;
    getBBox(): BBox;
    private initCrossLine;
    private isAnySeriesActive;
    clipTickLines(x: number, y: number, width: number, height: number): void;
    clipGrid(x: number, y: number, width: number, height: number): void;
    protected getTitleFormatterParams(): {
        direction: ChartAxisDirection;
        boundSeries: AgAxisBoundSeries[];
        defaultValue: string | undefined;
    };
    protected normaliseDataDomain(d: D[]): {
        domain: D[];
        clipped: boolean;
    };
    getLayoutState(): AxisLayout;
    private readonly moduleMap;
    getModuleMap(): AxisModuleMap;
    createModuleContext(): ModuleContextWithParent<AxisContext>;
    createAxisContext(): AxisContext;
    private animateReadyUpdate;
    protected resetSelectionNodes(): void;
    isReversed(): boolean;
}
export {};
