import type { FromToFns } from '../../motion/fromToMotion';
import type { Group, TransformableGroup } from '../../scene/group';
import type { Line } from '../../scene/shape/line';
import type { RotatableText, TransformableText } from '../../scene/shape/text';
import type { TranslatableType } from '../../scene/transformable';
export interface AxisLineDatum {
    x: number;
    y1: number;
    y2: number;
}
interface AxisAnimationContext {
    visible: boolean;
    min: number;
    max: number;
}
interface AxisGroupDatum {
    rotation: number;
    rotationCenterX: number;
    rotationCenterY: number;
    translationX: number;
    translationY: number;
}
interface AxisNodeDatum {
    translationY: number;
    tickId: string;
    visible: boolean;
}
interface AxisLabelDatum {
    tickId: string;
    x: number;
    y: number;
    rotation: number;
    rotationCenterX: number;
    translationY: number;
    range: number[];
}
export declare function prepareAxisAnimationContext(axis: {
    range: number[];
}): AxisAnimationContext;
export declare function prepareAxisAnimationFunctions(ctx: AxisAnimationContext): {
    tick: FromToFns<TranslatableType<Line>, any, AxisNodeDatum>;
    line: FromToFns<Line, any, AxisLineDatum>;
    label: FromToFns<TransformableText, Partial<Omit<AxisLabelDatum, "range">>, AxisLabelDatum>;
    group: FromToFns<TransformableGroup, any, AxisGroupDatum>;
};
export declare function resetAxisGroupFn(): (_node: Group, datum: AxisGroupDatum) => {
    rotation: number;
    rotationCenterX: number;
    rotationCenterY: number;
    translationX: number;
    translationY: number;
};
export declare function resetAxisSelectionFn(ctx: AxisAnimationContext): (_node: Line, datum: AxisNodeDatum) => {
    y: number;
    translationY: number;
    opacity: number;
    visible: boolean;
};
export declare function resetAxisLabelSelectionFn(): (_node: RotatableText, datum: AxisLabelDatum) => {
    x: number;
    y: number;
    translationY: number;
    rotation: number;
    rotationCenterX: number;
};
export declare function resetAxisLineSelectionFn(): (_node: Line, datum: AxisLineDatum) => {
    x: number;
    y1: number;
    y2: number;
};
export {};
