import type { AgCartesianAxisPosition } from 'ag-charts-types';
import type { AxisContext } from '../../module/axisContext';
import type { Scale } from '../../scale/scale';
import { ChartAxisDirection } from '../chartAxisDirection';
import { Axis } from './axis';
import { CartesianAxisLabel } from './cartesianAxisLabel';
export declare abstract class CartesianAxis<S extends Scale<D, number, any> = Scale<any, number, any>, D = any> extends Axis<S, D> {
    static is(value: unknown): value is CartesianAxis<any>;
    thickness?: number;
    position: AgCartesianAxisPosition;
    get direction(): ChartAxisDirection;
    protected updateDirection(): void;
    update(animated?: boolean): void;
    calculateLayout(domain?: any[], primaryTickCount?: number): {
        primaryTickCount: number | undefined;
        bbox: import("../../integrated-charts-scene").BBox;
    };
    createAxisContext(): AxisContext;
    protected createLabel(): CartesianAxisLabel;
}
