import type { ModuleContext } from '../../module/moduleContext';
import { BandScale } from '../../scale/bandScale';
import type { OrdinalTimeScale } from '../../scale/ordinalTimeScale';
import { CartesianAxis } from './cartesianAxis';
export declare class CategoryAxis<S extends BandScale<string | object, number> | OrdinalTimeScale = BandScale<string | object, number>> extends CartesianAxis<S> {
    static is(this: void, value: unknown): value is CategoryAxis<any>;
    static readonly className: string;
    static readonly type: 'category' | 'grouped-category' | 'ordinal-time';
    constructor(moduleCtx: ModuleContext, scale?: S);
    groupPaddingInner: number;
    paddingInner?: number;
    paddingOuter?: number;
    private domainOrderedToNormalizedDomain;
    private categoryAnimatable;
    protected calculateDomain(): void;
    update(): void;
    normaliseDataDomain(d: Array<string | object>): {
        domain: (string | object)[];
        clipped: boolean;
    };
    updateScale(opts?: {
        domain?: any[];
        skipDomainCalculation?: boolean;
    }): void;
    private reduceBandScalePadding;
}
