import type { FontStyle, FontWeight, TextAlign, TextWrap } from 'ag-charts-types';
import type { ModuleContext } from '../module/moduleContext';
import { RotatableText } from '../scene/shape/text';
import { BaseProperties } from '../util/properties';
import type { CaptionLike } from './captionLike';
export declare class Caption extends BaseProperties implements CaptionLike {
    static readonly SMALL_PADDING = 10;
    static readonly LARGE_PADDING = 20;
    readonly id: string;
    readonly node: RotatableText;
    enabled: boolean;
    text?: string;
    textAlign: TextAlign;
    fontStyle?: FontStyle;
    fontWeight?: FontWeight;
    fontSize: number;
    fontFamily: string;
    color?: string;
    spacing?: number;
    maxWidth?: number;
    maxHeight?: number;
    wrapping: TextWrap;
    padding: number;
    layoutStyle: 'block' | 'overlay';
    private truncated;
    private proxyText?;
    registerInteraction(moduleCtx: ModuleContext, where: 'beforebegin' | 'afterend'): () => void;
    computeTextWrap(containerWidth: number, containerHeight: number): void;
    private updateA11yText;
    private handleMouseMove;
    private handleMouseLeave;
}
