import type { LayoutContext } from '../module/baseModule';
import type { ChartOptions } from '../module/optionsModule';
import type { BBox } from '../scene/bbox';
import type { TransferableResources } from './chart';
import { Chart } from './chart';
import type { ChartAxis } from './chartAxis';
import type { Series } from './series/series';
export declare class CartesianChart extends Chart {
    static readonly className = "CartesianChart";
    static readonly type = "cartesian";
    static AxesPadding: number;
    /** Integrated Charts feature state - not used in Standalone Charts. */
    readonly paired: boolean;
    private lastAreaWidths?;
    constructor(options: ChartOptions, resources?: TransferableResources);
    private firstSeriesTranslation;
    onAxisChange(newValue: ChartAxis[], oldValue?: ChartAxis[]): void;
    destroySeries(series: Series<any, any>[]): void;
    getChartType(): "cartesian";
    private setRootClipRects;
    private lastUpdateClipRect;
    protected performLayout(ctx: LayoutContext): void;
    updateAxes(layoutBox: BBox): {
        clipSeries: boolean;
        seriesRect: BBox;
        visible: boolean;
    };
    private resolveAxesLayout;
    private updateAxesPass;
    private buildCrossLinePadding;
    private clampToOutsideSeriesRect;
    private getSyncedDomain;
    private sizeAxis;
    private positionAxes;
    private shouldFlipXY;
    private getDefaultState;
    private isLayoutStable;
    private clipAxis;
}
