import type { AgChartInstance, AgChartOptions } from 'ag-charts-types';
import type { LayoutContext } from '../module/baseModule';
import type { ModuleContext } from '../module/moduleContext';
import type { ChartOptions } from '../module/optionsModule';
import { BBox } from '../scene/bbox';
import { TranslatableGroup } from '../scene/group';
import type { Scene } from '../scene/scene';
import { Observable } from '../util/observable';
import { Padding } from '../util/padding';
import { BaseProperties } from '../util/properties';
import { Caption } from './caption';
import type { ChartAnimationPhase } from './chartAnimationPhase';
import type { ChartAxis } from './chartAxis';
import { ChartContext } from './chartContext';
import { ChartHighlight } from './chartHighlight';
import type { ChartMode } from './chartMode';
import { ChartUpdateType } from './chartUpdateType';
import { Keyboard } from './keyboard';
import { ModulesManager } from './modulesManager';
import { ChartOverlays } from './overlay/chartOverlays';
import { type Series } from './series/series';
import { SeriesAreaManager } from './series/seriesAreaManager';
import { SeriesLayerManager } from './series/seriesLayerManager';
import { Tooltip } from './tooltip/tooltip';
import type { UpdateOpts } from './updateService';
export type TransferableResources = {
    container?: HTMLElement;
    styleContainer?: HTMLElement;
    scene: Scene;
};
declare class SeriesArea extends BaseProperties {
    clip?: boolean;
    padding: Padding;
}
export declare abstract class Chart extends Observable {
    private static readonly chartsInstances;
    static getInstance(element: HTMLElement): Chart | undefined;
    readonly id: string;
    className?: string;
    readonly seriesRoot: TranslatableGroup;
    readonly annotationRoot: TranslatableGroup;
    private readonly titleGroup;
    readonly tooltip: Tooltip;
    readonly overlays: ChartOverlays;
    readonly highlight: ChartHighlight;
    private readonly debug;
    private extraDebugStats;
    container?: HTMLElement;
    data: any;
    width?: number;
    height?: number;
    minWidth?: number;
    minHeight?: number;
    /** NOTE: This is exposed for use by Integrated charts only. */
    get canvasElement(): HTMLCanvasElement;
    private _lastAutoSize?;
    private _firstAutoSize;
    private readonly _autoSizeNotify;
    download(fileName?: string, fileFormat?: string): void;
    getCanvasDataURL(fileFormat?: string): string;
    toSVG(): string | undefined;
    readonly padding: Padding;
    readonly seriesArea: SeriesArea;
    readonly keyboard: Keyboard;
    mode: ChartMode;
    private readonly chartCaptions;
    readonly title: Caption;
    readonly subtitle: Caption;
    readonly footnote: Caption;
    suppressFieldDotNotation: boolean;
    destroyed: boolean;
    private readonly _destroyFns;
    protected skipSync: boolean;
    chartAnimationPhase: ChartAnimationPhase;
    readonly modulesManager: ModulesManager;
    readonly ctx: ChartContext;
    protected readonly seriesLayerManager: SeriesLayerManager;
    protected readonly seriesAreaManager: SeriesAreaManager;
    private readonly processors;
    queuedUserOptions: AgChartOptions[];
    queuedChartOptions: ChartOptions[];
    chartOptions: ChartOptions;
    private firstApply;
    /**
     * Public API for this Chart instance. NOTE: This is initialized after construction by the
     * wrapping class that implements AgChartInstance.
     */
    publicApi?: AgChartInstance;
    getOptions(): import("ag-charts-types").AgCartesianChartOptions | import("ag-charts-types").AgPolarChartOptions | import("ag-charts-types").AgHierarchyChartOptions | import("ag-charts-types").AgTopologyChartOptions | import("ag-charts-types").AgFlowProportionChartOptions | import("ag-charts-types").AgStandaloneChartOptions;
    getChartOptions(): ChartOptions<AgChartOptions>;
    protected constructor(options: ChartOptions, resources?: TransferableResources);
    private initSeriesAreaDependencies;
    getModuleContext(): ModuleContext;
    abstract getChartType(): 'cartesian' | 'polar' | 'hierarchy' | 'topology' | 'flow-proportion' | 'standalone' | 'gauge';
    protected getCaptionText(): string;
    protected getAriaLabel(): string;
    resetAnimations(): void;
    skipAnimations(): void;
    detachAndClear(): void;
    destroy(opts?: {
        keepTransferableResources: boolean;
    }): TransferableResources | undefined;
    requestFactoryUpdate(cb: (chart: Chart) => Promise<void> | void): void;
    private _pendingFactoryUpdatesCount;
    private _performUpdateSkipAnimations;
    private readonly _performUpdateNotify;
    private performUpdateType;
    private runningUpdateType;
    private updateShortcutCount;
    private readonly seriesToUpdate;
    private readonly updateMutex;
    private updateRequestors;
    private readonly performUpdateTrigger;
    update(type?: ChartUpdateType, opts?: UpdateOpts): void;
    private readonly _performUpdateSplits;
    private performUpdate;
    private updateThemeClassName;
    private updateDOM;
    private updateAriaLabels;
    private checkUpdateShortcut;
    private checkFirstAutoSize;
    axes: ChartAxis[];
    series: Series<any, any>[];
    protected onAxisChange(newValue: ChartAxis[], oldValue?: ChartAxis[]): void;
    protected onSeriesChange(newValue: Series<any, any>[], oldValue?: Series<any, any>[]): void;
    protected destroySeries(allSeries: Series<any, any>[]): void;
    private addSeriesListeners;
    protected assignSeriesToAxes(): void;
    protected assignAxesToSeries(): void;
    private parentResize;
    private resize;
    updateData(): Promise<void>;
    private _cachedData;
    processData(): Promise<void>;
    private updateLegends;
    private setCategoryLegendData;
    private setLegendData;
    private processLayout;
    protected abstract performLayout(ctx: LayoutContext): Promise<void> | void;
    protected seriesRect?: BBox;
    protected animationRect?: BBox;
    private updateSeries;
    private readonly onSeriesNodeClick;
    private readonly onSeriesNodeDoubleClick;
    private readonly onSeriesVisibilityChange;
    private readonly seriesGroupingChanged;
    waitForUpdate(timeoutMs?: number, failOnTimeout?: boolean): Promise<void>;
    protected getMinRects(): {
        minRect: BBox;
        minVisibleRect: BBox;
    } | undefined;
    private filterMiniChartSeries;
    applyOptions(newChartOptions: ChartOptions): void;
    private applyInitialState;
    private maybeResetAnimations;
    private shouldForceNodeDataRefresh;
    private applyMiniChartOptions;
    private applyModules;
    private initSeriesDeclarationOrder;
    private applySeries;
    private applyAxes;
    private createSeries;
    private applySeriesOptionModules;
    private applySeriesValues;
    private createAxis;
    private applyAxisModules;
    private registerListeners;
}
export {};
