import type { AgBaseCrossLineLabelOptions, AgCrossLineLabelPosition } from 'ag-charts-types';
import type { Scale } from '../../scale/scale';
import type { Group } from '../../scene/group';
import type { TimeInterval } from '../../util/time/interval';
import type { ChartAxisDirection } from '../chartAxisDirection';
export type CrossLineType = 'line' | 'range';
export declare const MATCHING_CROSSLINE_TYPE: (property: 'value' | 'range') => import("../../util/validation").ValidatePredicate;
export declare const validateCrossLineValues: (type: 'line' | 'range', value: any, range: any, scale: Scale<any, number>, visibilityCheck?: () => boolean) => boolean;
export interface CrossLine<LabelType = AgBaseCrossLineLabelOptions> {
    calculateLayout?(visible: boolean, reversedAxis?: boolean): void;
    calculatePadding?(padding: Partial<Record<AgCrossLineLabelPosition, number>>): void;
    clippedRange: [number, number];
    direction: ChartAxisDirection;
    enabled?: boolean;
    fill?: string;
    fillOpacity?: number;
    gridLength: number;
    lineGroup: Group;
    rangeGroup: Group;
    id: string;
    label: LabelType;
    labelGroup: Group;
    lineDash?: number[];
    parallelFlipRotation: number;
    range?: [any, any];
    regularFlipRotation: number;
    scale?: Scale<any, number, number | TimeInterval>;
    sideFlag: 1 | -1;
    stroke?: string;
    strokeOpacity?: number;
    strokeWidth?: number;
    type?: CrossLineType;
    update(visible: boolean): void;
    value?: any;
    set(properties: object): void;
}
