import type { ChartMode } from '../chartMode';
import { RangeLookup } from './rangeLookup';
export interface ScopeProvider {
    id: string;
}
export interface DataGroup {
    keys: any[];
    datumIndices: number[];
    aggregation: any[][];
    validScopes: Set<string> | undefined;
}
export interface UngroupedDataItem<I, D, V> {
    index: I;
    keys: any[];
    values: V;
    aggValues?: [number, number][];
    datum: D;
    validScopes?: Set<string>;
}
declare const DOMAIN_RANGES: unique symbol;
export interface UngroupedData<D> {
    type: 'ungrouped';
    input: {
        count: number;
    };
    rawData: any[];
    rawDataSources?: Map<string, any[]>;
    aggregation: [number, number][][] | undefined;
    invalidKeys: boolean[] | undefined;
    invalidDataScopes: Map<string, boolean[]> | undefined;
    invalidData: boolean[] | undefined;
    keys: any[][];
    columns: any[][];
    domain: {
        keys: any[][];
        values: any[][];
        groups?: any[][];
        aggValues?: [number, number][];
    };
    reduced?: {
        diff?: Record<string, ProcessedOutputDiff>;
        smallestKeyInterval?: number;
        largestKeyInterval?: number;
        sortedGroupDomain?: any[][];
        animationValidation?: {
            uniqueKeys: boolean;
            orderedKeys: boolean;
        };
    };
    defs: {
        keys: DatumPropertyDefinition<keyof D>[];
        values: DatumPropertyDefinition<keyof D>[];
        allScopesHaveSameDefs: boolean;
    };
    partialValidDataCount: number;
    time: number;
    [DOMAIN_RANGES]: Map<string, RangeLookup>;
}
export type ProcessedOutputDiff = {
    changed: boolean;
    added: Set<string>;
    updated: Set<string>;
    removed: Set<string>;
    moved: Set<string>;
};
export type GroupedDataItem<D> = UngroupedDataItem<number[], D[], any[][]> & {
    area?: number;
};
export interface ProcessedDataDef {
    index: number;
    def: PropertyDefinition<any>;
}
export interface GroupedData<D> {
    type: 'grouped';
    input: UngroupedData<D>['input'];
    rawData: any[];
    rawDataSources?: Map<string, any[]>;
    groups: DataGroup[];
    keys: any[][];
    invalidKeys: boolean[] | undefined;
    invalidDataScopes: Map<string, boolean[]> | undefined;
    invalidData: boolean[] | undefined;
    columns: any[][];
    domain: UngroupedData<D>['domain'];
    reduced?: UngroupedData<D>['reduced'];
    defs: UngroupedData<D>['defs'];
    partialValidDataCount: number;
    time: number;
    [DOMAIN_RANGES]: UngroupedData<D>[typeof DOMAIN_RANGES];
}
export type ProcessedData<D> = UngroupedData<D> | GroupedData<D>;
export type DatumPropertyType = 'range' | 'category';
export declare function fixNumericExtent(extent: Array<number | Date> | null): [] | [number, number];
type MissMap = Map<string | undefined, number>;
export declare function getMissCount(scopeProvider: ScopeProvider, missMap: MissMap | undefined): number;
type GroupingFn<K> = (data: UngroupedDataItem<number, K, any[]>) => K[];
export type GroupByFn = (extractedData: UngroupedData<any>) => GroupingFn<any>;
export type DataModelOptions<K, Grouped extends boolean | undefined> = {
    scopes?: string[];
    props: PropertyDefinition<K>[];
    groupByKeys?: Grouped;
    groupByData?: Grouped;
    groupByFn?: GroupByFn;
};
export type PropertyDefinition<K> = DatumPropertyDefinition<K> | AggregatePropertyDefinition<any, any, any> | PropertyValueProcessorDefinition<any> | GroupValueProcessorDefinition<any, any> | ReducerOutputPropertyDefinition<any> | ProcessorOutputPropertyDefinition<any>;
export type ProcessorFn = (datum: any, previousDatum?: any) => any;
export type PropertyId<K extends string> = K | {
    id: string;
};
type PropertyIdentifiers = {
    /** Scope(s) a property definition belongs to (typically the defining entities unique identifier). */
    scopes?: string[];
    id?: string;
    /** Map<Scope, Set<Id>> */
    idsMap?: Map<string, Set<string>>;
    /** Optional group a property belongs to, for cross-scope combination. */
    groupId?: string;
};
type PropertySelectors = {
    /** Optional group a property belongs to, for cross-scope combination. */
    matchGroupIds?: string[];
};
export type DatumPropertyDefinition<K> = PropertyIdentifiers & {
    type: 'key' | 'value';
    valueType: DatumPropertyType;
    property: K;
    forceValue?: any;
    includeProperty?: boolean;
    invalidValue?: any;
    missing?: MissMap;
    missingValue?: any;
    separateNegative?: boolean;
    validation?: (value: any, datum: any, index: number) => boolean;
    processor?: () => ProcessorFn;
};
export type AggregatePropertyDefinition<D, K extends keyof D & string, R = [number, number], R2 = R> = PropertyIdentifiers & PropertySelectors & {
    type: 'aggregate';
    aggregateFunction: (values: D[K][], keys?: D[K][]) => R;
    groupAggregateFunction?: (next?: R, acc?: R2) => R2;
    finalFunction?: (result: R2) => [number, number];
};
type GroupValueAdjustFn<D, K extends keyof D & string> = (columns: D[K][][], indexes: number[], index: number) => void;
export type GroupValueProcessorDefinition<D, K extends keyof D & string> = PropertyIdentifiers & PropertySelectors & {
    type: 'group-value-processor';
    /**
     * Outer function called once per all data processing; inner function called once per group;
     * innermost called once per datum.
     */
    adjust: () => () => GroupValueAdjustFn<D, K>;
};
type PropertyValueAdjustFn<D> = (processedData: ProcessedData<D>, valueIndex: number) => void;
export type PropertyValueProcessorDefinition<D> = PropertyIdentifiers & {
    type: 'property-value-processor';
    property: string;
    adjust: () => PropertyValueAdjustFn<D>;
};
type ReducerOutputTypes = NonNullable<UngroupedData<any>['reduced']>;
type ReducerOutputKeys = keyof ReducerOutputTypes;
export type ReducerOutputPropertyDefinition<P extends ReducerOutputKeys = ReducerOutputKeys> = PropertyIdentifiers & {
    type: 'reducer';
    property: P;
    initialValue?: ReducerOutputTypes[P];
    reducer: () => (acc: ReducerOutputTypes[P], next: UngroupedDataItem<any, any, any>) => ReducerOutputTypes[P];
};
export type ProcessorOutputPropertyDefinition<P extends ReducerOutputKeys = ReducerOutputKeys> = PropertyIdentifiers & {
    type: 'processor';
    property: P;
    calculate: (data: ProcessedData<any>, previousValue: ReducerOutputTypes[P] | undefined) => ReducerOutputTypes[P];
};
export declare function datumKeys(keys: any[][], datumIndex: number): any[] | undefined;
export declare function getPathComponents(path: string): string[] | undefined;
export declare class DataModel<D extends object, K extends keyof D & string = keyof D & string, Grouped extends boolean | undefined = undefined> {
    private readonly opts;
    private readonly mode;
    private readonly suppressFieldDotNotation;
    private readonly debug;
    private readonly scopeCache;
    private readonly keys;
    private readonly values;
    private readonly aggregates;
    private readonly groupProcessors;
    private readonly propertyProcessors;
    private readonly reducers;
    private readonly processors;
    constructor(opts: DataModelOptions<K, Grouped>, mode?: ChartMode, suppressFieldDotNotation?: boolean);
    resolveProcessedDataDefById(scope: ScopeProvider, searchId: string): ProcessedDataDef | never;
    resolveProcessedDataIndexById(scope: ScopeProvider, searchId: string): number;
    resolveProcessedDataDefsByIds<T extends string>(scope: ScopeProvider, searchIds: T[]): [T, ProcessedDataDef][];
    resolveKeysById<T = string>(scope: ScopeProvider, searchId: string, processedData: UngroupedData<any> | GroupedData<any>): (T | undefined)[];
    resolveColumnById<T = any>(scope: ScopeProvider, searchId: string, processedData: UngroupedData<any> | GroupedData<any>): T[];
    resolveProcessedDataDefsValues<T extends string>(defs: [T, ProcessedDataDef][], { keys, values }: {
        keys: unknown[];
        values: unknown[];
    }): Record<T, any>;
    getDomain(scope: ScopeProvider, searchId: string, type: PropertyDefinition<any>['type'], processedData: ProcessedData<K>): any[] | [number, number] | [];
    getDomainBetweenRange(scope: ScopeProvider, searchIds: string[], [i0, i1]: [number, number], processedData: ProcessedData<K>): [number, number];
    private getDomainsByType;
    processData(data: D[], sources?: {
        id: string;
        data: D[];
    }[]): (Grouped extends true ? GroupedData<D> : UngroupedData<D>) | undefined;
    private warnDataMissingProperties;
    private processScopeCache;
    private valueGroupIdxLookup;
    private valueIdxLookup;
    private extractData;
    private groupData;
    private aggregateData;
    private postProcessGroups;
    private postProcessProperties;
    private reduceData;
    private postProcessData;
    private initDataDomainProcessor;
    buildAccessors(defs: Iterable<{
        property: string;
    }>): Map<string, (d: any) => any>;
}
export {};
