import type { AgContextMenuOptions } from 'ag-charts-types';
import type { CategoryLegendDatum } from '../legend/legendDatum';
import type { ISeries, SeriesNodeDatum } from '../series/seriesTypes';
import { type PreventableEvent } from './preventableEvent';
import type { RegionEvent } from './regionManager';
type ContextTypeMap = {
    all: object;
    legend: {
        legendItem: CategoryLegendDatum | undefined;
    };
    'series-area': {
        pickedSeries: ISeries<any, any> | undefined;
        pickedNode: SeriesNodeDatum | undefined;
    };
    node: {
        pickedSeries: ISeries<any, any> | undefined;
        pickedNode: SeriesNodeDatum | undefined;
    };
};
type ContextEventProperties<K extends ContextType = ContextType> = {
    type: K;
    x: number;
    y: number;
    context: ContextTypeMap[K];
    sourceEvent: Event;
};
type ContextMenuActionEventMap = {
    all: Parameters<NonNullable<AgContextMenuOptions['extraActions']>[number]['action']>[0];
    legend: Parameters<NonNullable<AgContextMenuOptions['extraLegendItemActions']>[number]['action']>[0];
    'series-area': Parameters<NonNullable<AgContextMenuOptions['extraSeriesAreaActions']>[number]['action']>[0];
    node: Parameters<NonNullable<AgContextMenuOptions['extraNodeActions']>[number]['action']>[0];
};
export type ContextType = keyof ContextTypeMap;
export type ContextMenuEvent<K extends ContextType = ContextType> = ContextEventProperties<K> & PreventableEvent;
export type ContextMenuCallback<K extends ContextType> = {
    all: (params: ContextMenuActionEventMap['all']) => void;
    legend: (params: ContextMenuActionEventMap['legend']) => void;
    'series-area': (params: ContextMenuActionEventMap['series-area']) => void;
    node: (params: ContextMenuActionEventMap['node']) => void;
}[K];
export type ContextMenuAction<K extends ContextType> = {
    id?: string;
    label: string;
    type: K;
    action: ContextMenuCallback<K>;
};
export declare class ContextMenuRegistry {
    private readonly defaultActions;
    private readonly disabledActions;
    private readonly hiddenActions;
    private readonly listeners;
    static check<T extends ContextType>(type: T, event: ContextMenuEvent): event is ContextMenuEvent<T>;
    static checkCallback<T extends ContextType>(desiredType: T, type: ContextType, _callback: ContextMenuCallback<ContextType>): _callback is ContextMenuCallback<T>;
    dispatchContext<T extends ContextType>(type: T, pointerEvent: Pick<RegionEvent<'contextmenu'>, 'sourceEvent' | 'canvasX' | 'canvasY'>, context: ContextTypeMap[T], position?: {
        x: number;
        y: number;
    }): void;
    addListener(handler: (event: ContextMenuEvent) => void): () => void;
    filterActions(type: ContextType): ContextMenuAction<ContextType>[];
    registerDefaultAction<T extends ContextType>(action: ContextMenuAction<T>): () => void;
    enableAction(actionId: string): void;
    disableAction(actionId: string): void;
    showAction(actionId: string): void;
    hideAction(actionId: string): void;
    isDisabled(actionId: string): boolean;
}
export {};
