import type { DOMManager } from '../../dom/domManager';
import { InteractionState, InteractionStateListener } from './interactionStateListener';
import { type PreventableEvent } from './preventableEvent';
export { InteractionState };
export declare const POINTER_INTERACTION_TYPES: readonly ["click", "dblclick", "contextmenu", "hover", "leave", "enter", "page-left", "wheel"];
declare const KEY_INTERACTION_TYPES: readonly ["keydown", "keyup"];
export type PointerInteractionTypes = (typeof POINTER_INTERACTION_TYPES)[number];
export type KeyInteractionTypes = (typeof KEY_INTERACTION_TYPES)[number];
export type InteractionTypes = PointerInteractionTypes | KeyInteractionTypes;
type BaseInteractionEvent<T extends InteractionTypes, TEvent extends Event> = PreventableEvent & {
    type: T;
    sourceEvent: TEvent;
    relatedElement?: HTMLElement;
    targetElement?: HTMLElement;
};
export type PointerOffsets = {
    offsetX: number;
    offsetY: number;
    pageX?: number;
    pageY?: number;
};
export type PointerHistoryEvent = PointerOffsets & {
    type: string;
};
export type PointerInteractionEvent<T extends PointerInteractionTypes = PointerInteractionTypes> = PointerOffsets & BaseInteractionEvent<T, Event> & {
    pageX: number;
    pageY: number;
    deltaX: number;
    deltaY: number;
    button: number;
    pointerHistory: PointerHistoryEvent[];
};
export type KeyInteractionEvent<T extends KeyInteractionTypes = KeyInteractionTypes> = BaseInteractionEvent<T, KeyboardEvent>;
export type InteractionEvent = PointerInteractionEvent<PointerInteractionTypes> | KeyInteractionEvent<KeyInteractionTypes>;
type SupportedEvent = MouseEvent | TouchEvent | Event;
/**
 * Manages user interactions with a specific HTMLElement (or interactions that bubble from it's
 * children)
 */
export declare class InteractionManager extends InteractionStateListener<InteractionTypes, InteractionEvent> {
    private readonly keyboardOptions;
    private readonly domManager;
    private readonly debug;
    private rootElement;
    private readonly eventHandler;
    private readonly clickHistory;
    private readonly dblclickHistory;
    private stateQueue;
    constructor(keyboardOptions: {
        readonly enabled: boolean;
    }, domManager: DOMManager);
    private containerChanged;
    destroy(): void;
    pushState(state: InteractionState): void;
    popState(state: InteractionState): void;
    getState(): InteractionState;
    private processEvent;
    private dispatchEvent;
    private dispatchTypedEvent;
    extractElements(event: SupportedEvent): {
        relatedElement?: HTMLElement;
        targetElement?: HTMLElement;
    };
    private dispatchPointerEvent;
    private getEventHTMLTarget;
    private recordDown;
    private recordUp;
    private decideInteractionEventTypes;
    private isEventOverElement;
    private static readonly NULL_COORDS;
    private calculateCoordinates;
    private getMouseEventCoords;
    private static isWheelEvent;
    static getWheelDeltas(event: Event): {
        deltaX: number;
        deltaY: number;
    };
    private buildPointerEvent;
}
