import { BaseManager } from '../../util/baseManager';
export declare enum InteractionState {
    Default = 32,
    ZoomDrag = 16,
    Annotations = 8,
    ContextMenu = 4,
    Animation = 2,
    AnnotationsSelected = 1,
    All = 63
}
export declare abstract class InteractionStateListener<TType extends string, TEvent extends {
    type: TType;
}> extends BaseManager<TType, TEvent> {
    protected abstract getState(): InteractionState;
    addListener<T extends TType>(type: T, handler: (event: TEvent & {
        type: T;
    }) => void, triggeringStates?: InteractionState): () => void;
}
