import type { FocusIndicator } from '../../dom/focusIndicator';
import type { InteractionEvent, InteractionManager } from './interactionManager';
import { InteractionState, InteractionStateListener } from './interactionStateListener';
import { type PreventableEvent } from './preventableEvent';
import type { RegionManager } from './regionManager';
export type KeyNavEventType = 'nav-hori' | 'nav-vert' | 'nav-zoom' | 'submit' | 'undo' | 'redo';
export type KeyNavEvent<T extends KeyNavEventType = KeyNavEventType> = PreventableEvent & {
    type: T;
    delta: -1 | 0 | 1;
    sourceEvent: InteractionEvent;
};
export declare class KeyNavManager extends InteractionStateListener<KeyNavEventType, KeyNavEvent> {
    readonly interactionManager: InteractionManager;
    private previousInputDevice;
    focusIndicator?: FocusIndicator;
    constructor(interactionManager: InteractionManager, regionManager: RegionManager);
    protected getState(): InteractionState;
    destroy(): void;
    private onClick;
    private onMouse;
    private onKeyDown;
    private dispatch;
}
