import type { Widget } from '../../widget/widget';
import { InteractionManager } from './interactionManager';
import type { PointerInteractionTypes } from './interactionManager';
import { InteractionState } from './interactionManager';
import { type PreventableEvent } from './preventableEvent';
type RegionName = 'root' | 'series';
type RegionInteractionTypes = PointerInteractionTypes | 'drag-start' | 'drag' | 'drag-end';
export type RegionEvent<T extends RegionInteractionTypes = RegionInteractionTypes> = PreventableEvent & {
    type: T;
    region: RegionName;
    regionX: number;
    regionY: number;
    canvasX: number;
    canvasY: number;
    deltaX: T extends 'wheel' ? number : never;
    deltaY: T extends 'wheel' ? number : never;
    sourceEvent: Event;
    timestamp: number;
};
export type MockEvent = {
    target: HTMLElement;
    offsetX: number;
    offsetY: number;
    mockRegion?: Pick<RegionEvent, 'region' | 'canvasX' | 'canvasY' | 'regionX' | 'regionY'>;
};
type TypeInfo = {
    [K in RegionInteractionTypes]: RegionEvent<K>;
};
export interface RegionProperties {
    readonly name: RegionName;
    widget?: Widget;
}
export declare class RegionManager {
    private readonly interactionManager;
    private readonly debug;
    private current?;
    private readonly regions;
    private readonly destroyFns;
    private readonly allRegionsListeners;
    private deferredDragStart?;
    private isDragMoving;
    private blockNextClickEvent;
    constructor(interactionManager: InteractionManager);
    destroy(): void;
    initRegions(root: Widget, series: Widget): void;
    getRegion(name: RegionName): {
        addListener<T extends RegionInteractionTypes>(type: T, handler: (event: TypeInfo[T]) => void, triggeringStates?: InteractionState): () => void;
    };
    listenAll<T extends RegionEvent['type']>(type: T, handler: (event: TypeInfo[T]) => void, triggeringStates?: InteractionState): () => void;
    private makeObserver;
    private widgetEventTypeToRegionEventType;
    private computeEventOffsets;
    private dispatch;
    private dispatchEvent;
    private readonly processPointerEvent;
    private pickRegion;
    private canStartDrag;
}
export {};
