import type { AgZoomRange, AgZoomRatio } from 'ag-charts-types';
import type { MementoOriginator } from '../../api/state/memento';
import type { Scale } from '../../scale/scale';
import type { BBox } from '../../scene/bbox';
import { BaseManager } from '../../util/baseManager';
import type { BBoxValues } from '../../util/bboxinterface';
import { ChartAxisDirection } from '../chartAxisDirection';
import type { LayoutManager } from '../layout/layoutManager';
import type { ISeries } from '../series/seriesTypes';
export interface ZoomState {
    min: number;
    max: number;
}
export interface AxisZoomState {
    x?: ZoomState;
    y?: ZoomState;
}
export interface DefinedZoomState {
    x: ZoomState;
    y: ZoomState;
}
export type ZoomMemento = {
    rangeX?: AgZoomRange;
    rangeY?: AgZoomRange;
    ratioX?: AgZoomRatio;
    ratioY?: AgZoomRatio;
    autoScaleYAxis?: boolean;
};
export interface ZoomChangeEvent extends AxisZoomState {
    type: 'zoom-change';
    callerId: string;
    axes: Record<string, ZoomState | undefined>;
}
export interface ZoomPanStartEvent {
    type: 'zoom-pan-start';
    callerId: string;
}
export type ChartAxisLike = {
    id: string;
    direction: ChartAxisDirection;
    visibleRange: [number, number];
    scale: Scale<any, any>;
    range: [number, number];
    boundSeries: ISeries<any, any>[];
};
type ZoomEvents = ZoomChangeEvent | ZoomPanStartEvent;
/**
 * Manages the current zoom state for a chart. Tracks the requested zoom from distinct dependents
 * and handles conflicting zoom requests.
 */
export declare class ZoomManager extends BaseManager<ZoomEvents['type'], ZoomEvents> implements MementoOriginator<ZoomMemento> {
    mementoOriginatorKey: "zoom";
    private readonly axisZoomManagers;
    private readonly state;
    private axes;
    private didLayoutAxes;
    private readonly autoScaleYAxis;
    private lastRestoredState;
    private independentAxes;
    private navigatorModule;
    private zoomModule;
    private pendingMemento;
    addLayoutListeners(layoutManager: LayoutManager): void;
    createMemento(): ZoomMemento;
    guardMemento(blob: unknown): blob is ZoomMemento | undefined;
    restoreMemento(_version: string, _mementoVersion: string, memento: ZoomMemento | undefined): void;
    updateAxes(axes: Array<ChartAxisLike>): void;
    setIndependentAxes(independent?: boolean): void;
    setAutoScaleYAxis(enabled: boolean, padding: number): void;
    setNavigatorEnabled(enabled?: boolean): void;
    setZoomModuleEnabled(enabled?: boolean): void;
    isZoomEnabled(): boolean;
    updateZoom(callerId: string, newZoom?: AxisZoomState): void;
    updateAxisZoom(callerId: string, axisId: string, newZoom?: ZoomState): void;
    resetZoom(callerId: string): void;
    resetAxisZoom(callerId: string, axisId: string): void;
    setAxisManuallyAdjusted(_callerId: string, axisId: string): void;
    updatePrimaryAxisZoom(callerId: string, direction: ChartAxisDirection, newZoom?: ZoomState): void;
    panToBBox(callerId: string, seriesRect: BBox, target: BBoxValues): void;
    fireZoomPanStartEvent(callerId: string): void;
    extendToEnd(callerId: string, direction: ChartAxisDirection, extent: number): void;
    extendWith(callerId: string, direction: ChartAxisDirection, fn: (end: Date | number) => Date | number): void;
    updateWith(callerId: string, direction: ChartAxisDirection, fn: (start: Date | number, end: Date | number) => [Date | number, Date | number]): void;
    getZoom(): AxisZoomState | undefined;
    getAxisZoom(axisId: string): ZoomState;
    getAxisZooms(): Record<string, {
        direction: ChartAxisDirection;
        zoom: ZoomState | undefined;
    }>;
    getRestoredZoom(): AxisZoomState | undefined;
    private autoScaleYZoom;
    private applyChanges;
    private getRangeDirection;
    private rangeToRatio;
    private getPrimaryAxis;
    private getDomainExtents;
    private getDomainPixelExtents;
    private getDefinedZoom;
    private zoomBounds;
    private primaryAxisZoom;
    private combinedAxisZoom;
}
export {};
