import type { FocusIndicator } from '../dom/focusIndicator';
import { BBox } from '../scene/bbox';
import type { Path } from '../scene/shape/path';
import { getDatumRefPoint } from './series/seriesTypes';
import type { TooltipPointerEvent } from './tooltip/tooltip';
type PickProperties = {
    bounds: Path | BBox | undefined;
    datum: Parameters<typeof getDatumRefPoint>[0];
    showFocusBox: boolean;
    clipFocusBox: boolean;
};
export declare function drawPickedFocus(seriesRect: BBox | undefined, focusIndicator: FocusIndicator | undefined, pick: PickProperties, fixmeTranslatePathX?: number, fixmeTranslatePathY?: number): void;
export declare function getPickedFocusBBox({ bounds }: PickProperties): BBox;
export declare function makeKeyboardPointerEvent(hoverRect: BBox, pick: PickProperties): TooltipPointerEvent<'keyboard'> | undefined;
export {};
