import type { AgChartLabelFormatterParams, AgChartLabelOptions, FontStyle, FontWeight, Formatter } from 'ag-charts-types';
import type { Matrix } from '../scene/matrix';
import type { PlacedLabelDatum } from '../scene/util/labelPlacement';
import { BaseProperties } from '../util/properties';
import { type TextMeasurer } from '../util/textMeasurer';
import type { RequireOptional } from '../util/types';
import type { ChartAxisLabelFlipFlag } from './chartAxis';
export declare class Label<TParams = never, TDatum = any> extends BaseProperties implements AgChartLabelOptions<TDatum, RequireOptional<TParams>> {
    enabled: boolean;
    color?: string;
    fontStyle?: FontStyle;
    fontWeight?: FontWeight;
    fontSize: number;
    fontFamily: string;
    formatter?: Formatter<AgChartLabelFormatterParams<TDatum> & RequireOptional<TParams>>;
    getFont(): string;
}
export declare function calculateLabelRotation(opts: {
    rotation?: number;
    parallel?: boolean;
    regularFlipRotation?: number;
    parallelFlipRotation?: number;
}): {
    configuredRotation: number;
    defaultRotation: number;
    parallelFlipFlag: ChartAxisLabelFlipFlag;
    regularFlipFlag: ChartAxisLabelFlipFlag;
};
export declare function getLabelSpacing(minSpacing: number, rotated?: boolean): number;
export declare function getTextBaseline(parallel: boolean, labelRotation: number, sideFlag: ChartAxisLabelFlipFlag, parallelFlipFlag: ChartAxisLabelFlipFlag): CanvasTextBaseline;
export declare function getTextAlign(parallel: boolean, labelRotation: number, labelAutoRotation: number, sideFlag: ChartAxisLabelFlipFlag, regularFlipFlag: ChartAxisLabelFlipFlag): CanvasTextAlign;
export declare function createLabelData(tickData: {
    tickLabel: string;
    translationY: number;
}[], labelX: number, labelMatrix: Matrix, textMeasurer: TextMeasurer): PlacedLabelDatum[];
