import type { LocaleManager } from '../../locale/localeManager';
import type { ModuleContext } from '../../module/moduleContext';
import type { Node } from '../../scene/node';
import type { Selection } from '../../scene/selection';
import type { SwitchWidget } from '../../widget/switchWidget';
import type { Page } from '../gridLayout';
import type { Pagination } from '../pagination/pagination';
import type { CategoryLegendDatum } from './legendDatum';
import type { LegendMarkerLabel } from './legendMarkerLabel';
type ItemSelection = Selection<LegendMarkerLabel, CategoryLegendDatum>;
type CategoryLegendDatumReader = {
    getItemLabel(datum: CategoryLegendDatum): string | undefined;
};
interface ButtonListener {
    onClick(event: Event, datum: CategoryLegendDatum, proxyButton: SwitchWidget): void;
    onDoubleClick(event: MouseEvent, datum: CategoryLegendDatum): void;
    onHover(event: FocusEvent | MouseEvent, node: LegendMarkerLabel): void;
    onLeave(): void;
    onContextClick(sourceEvent: MouseEvent, node: LegendMarkerLabel): void;
}
type LegendDOMProxyUpdateParams = {
    visible: boolean;
    interactive: boolean;
    ctx: Pick<ModuleContext, 'proxyInteractionService' | 'localeManager'>;
    itemSelection: ItemSelection;
    group: Node;
    pagination: Pagination;
    oldPages: Page[] | undefined;
    newPages: Page[];
    datumReader: CategoryLegendDatumReader;
    itemListener: ButtonListener;
};
type LegendDOMProxyPageChangeParams = Pick<LegendDOMProxyUpdateParams, 'itemSelection' | 'group' | 'pagination' | 'interactive'>;
export declare class LegendDOMProxy {
    private readonly idPrefix;
    private dirty;
    private readonly itemList;
    private readonly itemDescription;
    private readonly paginationGroup;
    private readonly destroyFns;
    private prevButton?;
    private nextButton?;
    constructor(ctx: Pick<ModuleContext, 'proxyInteractionService' | 'localeManager'>, idPrefix: string);
    destroy(): void;
    private initLegendList;
    update(params: LegendDOMProxyUpdateParams): void;
    private updateVisibility;
    private updateItemProxyButtons;
    private updatePaginationProxyButtons;
    private updatePaginationCursors;
    onDataUpdate(oldData: CategoryLegendDatum[], newData: CategoryLegendDatum[]): void;
    onLocaleChanged(localeManager: LocaleManager, itemSelection: ItemSelection, datumReader: CategoryLegendDatumReader): void;
    onPageChange(params: LegendDOMProxyPageChangeParams): void;
    private getItemAriaText;
    private getItemAriaDescription;
}
export {};
