import type { FontStyle, FontWeight } from 'ag-charts-types';
import { BBox } from '../../scene/bbox';
import { Group } from '../../scene/group';
import type { Line } from '../../scene/shape/line';
import type { SpriteDimensions, SpriteRenderer } from '../../scene/spriteRenderer';
import type { SwitchWidget } from '../../widget/switchWidget';
import type { Marker } from '../marker/marker';
declare const LegendMarkerLabel_base: new (...args: any[]) => import("../../scene/transformable").TranslatableType<Group>;
export declare class LegendMarkerLabel extends LegendMarkerLabel_base {
    static readonly className = "MarkerLabel";
    private readonly label;
    private readonly symbolsGroup;
    private readonly bitmap;
    private bitmapDirty;
    private enabled;
    constructor();
    destroy(): void;
    proxyButton?: SwitchWidget;
    pageIndex: number;
    text?: string;
    fontStyle?: FontStyle;
    fontWeight?: FontWeight;
    fontSize?: number;
    fontFamily?: string;
    color?: string;
    private _marker;
    get marker(): Marker | undefined;
    private _line;
    get line(): Line | undefined;
    updateSymbols(marker: Marker | undefined, line: Line | undefined): void;
    setEnabled(enabled: boolean): void;
    private refreshVisibilities;
    private setBitmapVisibility;
    update(spriteRenderer: SpriteRenderer, { spriteAAPadding, spritePixelRatio: scale }: SpriteDimensions, dimensionProps: {
        length: number;
        spacing: number;
        isCustomMarker: boolean;
    }): void;
    protected computeBBox(): BBox;
}
export {};
