import type { ModuleContext } from '../../../module/moduleContext';
import { BBox } from '../../../scene/bbox';
import type { Point } from '../../../scene/point';
import { Selection } from '../../../scene/selection';
import { Rect } from '../../../scene/shape/rect';
import type { Text } from '../../../scene/shape/text';
import { ChartAxisDirection } from '../../chartAxisDirection';
import type { DataController } from '../../data/dataController';
import { DataModel, type ProcessedData } from '../../data/dataModel';
import type { CategoryLegendDatum, ChartLegendType } from '../../legend/legendDatum';
import { type TooltipContent } from '../../tooltip/tooltip';
import { type PickFocusInputs } from '../series';
import type { ErrorBoundSeriesNodeDatum } from '../seriesTypes';
import { AbstractBarSeries } from './abstractBarSeries';
import { BarSeriesProperties } from './barSeriesProperties';
import { type CartesianAnimationData, type CartesianSeriesNodeDataContext, type CartesianSeriesNodeDatum } from './cartesianSeries';
import { type Scaling } from './scaling';
interface BarNodeLabelDatum extends Readonly<Point> {
    readonly text: string;
    readonly textAlign: CanvasTextAlign;
    readonly textBaseline: CanvasTextBaseline;
}
interface BarNodeDatum extends CartesianSeriesNodeDatum, ErrorBoundSeriesNodeDatum, Readonly<Point> {
    readonly xValue: string | number;
    readonly yValue: string | number;
    readonly valueIndex: number;
    readonly cumulativeValue: number;
    readonly phantom: boolean;
    readonly width: number;
    readonly height: number;
    readonly fill: string | undefined;
    readonly stroke: string | undefined;
    readonly opacity: number | undefined;
    readonly strokeWidth: number;
    readonly cornerRadius: number;
    readonly topLeftCornerRadius: boolean;
    readonly topRightCornerRadius: boolean;
    readonly bottomRightCornerRadius: boolean;
    readonly bottomLeftCornerRadius: boolean;
    readonly clipBBox: BBox | undefined;
    readonly label?: BarNodeLabelDatum;
}
type BarAnimationData = CartesianAnimationData<Rect, BarNodeDatum>;
interface BarSeriesNodeDataContext extends CartesianSeriesNodeDataContext<BarNodeDatum, BarNodeDatum> {
    groupScale: Scaling | undefined;
}
export interface BarSeriesAggregationIndexes {
    xMin: 0;
    xMax: 1;
    yMin: 2;
    yMax: 3;
    span: 4;
}
export interface BarSeriesDataAggregationFilter {
    maxRange: number;
    indexData: Int32Array;
    indexes: BarSeriesAggregationIndexes;
}
export declare class BarSeries extends AbstractBarSeries<Rect, BarSeriesProperties, BarNodeDatum, BarNodeDatum, BarSeriesNodeDataContext> {
    static readonly className = "BarSeries";
    static readonly type: "bar";
    properties: BarSeriesProperties;
    connectsToYAxis: boolean;
    private dataAggregationFilters;
    get pickModeAxis(): "main" | undefined;
    constructor(moduleCtx: ModuleContext);
    private crossFilteringEnabled;
    processData(dataController: DataController): Promise<void>;
    getSeriesDomain(direction: ChartAxisDirection): any[];
    getSeriesRange(_direction: ChartAxisDirection, visibleRange: [any, any]): [number, number];
    protected aggregateData(_dataModel: DataModel<any, any, any>, _processedData: ProcessedData<any>): BarSeriesDataAggregationFilter[] | undefined;
    protected visibleRange(length: number, _x0: number, _x1: number, _xFor: (index: number) => number): [number, number];
    createNodeData(): {
        itemId: string;
        nodeData: BarNodeDatum[];
        labelData: BarNodeDatum[];
        scales: {
            x?: Scaling | undefined;
            y?: Scaling | undefined;
        };
        visible: boolean;
        groupScale: Scaling | undefined;
    } | undefined;
    protected nodeFactory(): Rect;
    protected getHighlightData(nodeData: BarNodeDatum[], highlightedItem: BarNodeDatum): BarNodeDatum[] | undefined;
    protected updateDatumSelection(opts: {
        nodeData: BarNodeDatum[];
        datumSelection: Selection<Rect, BarNodeDatum>;
    }): Selection<Rect, BarNodeDatum>;
    private getItemBaseStyle;
    private getItemStyleOverrides;
    protected updateDatumNodes(opts: {
        datumSelection: Selection<Rect, BarNodeDatum>;
        isHighlight: boolean;
    }): void;
    protected updateLabelSelection(opts: {
        labelData: BarNodeDatum[];
        labelSelection: Selection<Text, BarNodeDatum>;
    }): Selection<Text, BarNodeDatum>;
    protected updateLabelNodes(opts: {
        labelSelection: Selection<Text, BarNodeDatum>;
    }): void;
    getTooltipContent(nodeDatum: BarNodeDatum): TooltipContent | string | undefined;
    private legendItemSymbol;
    getLegendData(legendType: ChartLegendType): CategoryLegendDatum[];
    animateEmptyUpdateReady({ datumSelection, labelSelection, annotationSelections }: BarAnimationData): void;
    animateWaitingUpdateReady(data: BarAnimationData): void;
    private getDatumId;
    protected isLabelEnabled(): boolean;
    protected computeFocusBounds({ datumIndex }: PickFocusInputs): BBox | undefined;
}
export {};
