import type { AgSeriesMarkerStyle } from 'ag-charts-types';
import type { ModuleContext } from '../../../module/moduleContext';
import type { BBox } from '../../../scene/bbox';
import { Group } from '../../../scene/group';
import type { Selection } from '../../../scene/selection';
import { Text } from '../../../scene/shape/text';
import type { PlacedLabel } from '../../../scene/util/labelPlacement';
import { ChartAxisDirection } from '../../chartAxisDirection';
import type { DataController } from '../../data/dataController';
import type { CategoryLegendDatum } from '../../legend/legendDatum';
import type { Marker } from '../../marker/marker';
import { type TooltipContent } from '../../tooltip/tooltip';
import type { PickFocusInputs, SeriesNodeEventTypes } from '../series';
import { type BubbleNodeDatum, BubbleSeriesProperties } from './bubbleSeriesProperties';
import type { CartesianAnimationData } from './cartesianSeries';
import { CartesianSeries, CartesianSeriesNodeEvent } from './cartesianSeries';
type BubbleAnimationData = CartesianAnimationData<Group, BubbleNodeDatum>;
declare class BubbleSeriesNodeEvent<TEvent extends string = SeriesNodeEventTypes> extends CartesianSeriesNodeEvent<TEvent> {
    readonly sizeKey?: string;
    constructor(type: TEvent, nativeEvent: Event, datum: BubbleNodeDatum, series: BubbleSeries);
}
export declare class BubbleSeries extends CartesianSeries<Group, BubbleSeriesProperties, BubbleNodeDatum> {
    static readonly className = "BubbleSeries";
    static readonly type: "bubble";
    protected readonly NodeEvent: typeof BubbleSeriesNodeEvent;
    protected clipFocusBox: boolean;
    properties: BubbleSeriesProperties;
    private readonly sizeScale;
    private readonly colorScale;
    get pickModeAxis(): "main-category";
    constructor(moduleCtx: ModuleContext);
    processData(dataController: DataController): Promise<void>;
    getSeriesDomain(direction: ChartAxisDirection): any[];
    getSeriesRange(_direction: ChartAxisDirection, _visibleRange: [any, any]): [number, number];
    createNodeData(): {
        itemId: string;
        nodeData: BubbleNodeDatum[];
        labelData: BubbleNodeDatum[];
        scales: {
            x?: import("./scaling").Scaling | undefined;
            y?: import("./scaling").Scaling | undefined;
        };
        visible: boolean;
    } | undefined;
    protected isPathOrSelectionDirty(): boolean;
    getLabelData(): BubbleNodeDatum[];
    protected markerFactory(): Marker;
    protected updateMarkerSelection(opts: {
        nodeData: BubbleNodeDatum[];
        markerSelection: Selection<Marker, BubbleNodeDatum>;
    }): Selection<Marker, BubbleNodeDatum>;
    private getMarkerItemBaseStyle;
    private getMarkerItemStyleOverrides;
    protected updateMarkerNodes(opts: {
        markerSelection: Selection<Marker, BubbleNodeDatum>;
        isHighlight: boolean;
    }): void;
    updatePlacedLabelData(labelData: PlacedLabel<BubbleNodeDatum>[]): void;
    protected updateLabelNodes(opts: {
        labelSelection: Selection<Text, BubbleNodeDatum>;
    }): void;
    getTooltipContent(nodeDatum: BubbleNodeDatum): TooltipContent | string | undefined;
    private legendItemSymbol;
    getLegendData(): CategoryLegendDatum[];
    animateEmptyUpdateReady({ markerSelection, labelSelection }: BubbleAnimationData): void;
    protected isLabelEnabled(): boolean;
    protected nodeFactory(): Group;
    getFormattedMarkerStyle(datum: BubbleNodeDatum): AgSeriesMarkerStyle & {
        size: number;
    };
    protected computeFocusBounds(opts: PickFocusInputs): BBox | undefined;
}
export {};
