import type { ModuleContext } from '../../../module/moduleContext';
import type { BBox } from '../../../scene/bbox';
import { Group } from '../../../scene/group';
import type { Selection } from '../../../scene/selection';
import type { Path } from '../../../scene/shape/path';
import type { Text } from '../../../scene/shape/text';
import { ChartAxisDirection } from '../../chartAxisDirection';
import type { DataController } from '../../data/dataController';
import type { DataModel, UngroupedData } from '../../data/dataModel';
import type { CategoryLegendDatum, ChartLegendType } from '../../legend/legendDatum';
import type { Marker } from '../../marker/marker';
import { type TooltipContent } from '../../tooltip/tooltip';
import { type PickFocusInputs } from '../series';
import type { CartesianAnimationData } from './cartesianSeries';
import { CartesianSeries } from './cartesianSeries';
import { LineSeriesProperties } from './lineSeriesProperties';
import { type LineNodeDatum, type LinePathSpan, type LineSeriesNodeDataContext } from './lineUtil';
type LineAnimationData = CartesianAnimationData<Group, LineNodeDatum, LineNodeDatum, LineSeriesNodeDataContext>;
export interface LineSeriesDataAggregationFilter {
    indices: number[];
    maxRange: number;
}
export declare class LineSeries extends CartesianSeries<Group, LineSeriesProperties, LineNodeDatum, LineNodeDatum, LineSeriesNodeDataContext> {
    static readonly className = "LineSeries";
    static readonly type: "line";
    protected clipFocusBox: boolean;
    properties: LineSeriesProperties;
    private dataAggregationFilters;
    get pickModeAxis(): "main" | "main-category";
    constructor(moduleCtx: ModuleContext);
    processData(dataController: DataController): Promise<void>;
    getSeriesDomain(direction: ChartAxisDirection): any[];
    private visibleRangeIndices;
    getSeriesRange(_direction: ChartAxisDirection, visibleRange: [any, any]): [number, number];
    protected aggregateData(_dataModel: DataModel<any, any, any>, _processedData: UngroupedData<any>): LineSeriesDataAggregationFilter[] | undefined;
    createNodeData(): {
        itemId: string;
        nodeData: LineNodeDatum[];
        labelData: LineNodeDatum[];
        strokeData: {
            itemId: string;
            spans: LinePathSpan[];
        } | undefined;
        scales: {
            x?: import("./scaling").Scaling | undefined;
            y?: import("./scaling").Scaling | undefined;
        };
        visible: boolean;
        crossFiltering: boolean;
    } | undefined;
    protected isPathOrSelectionDirty(): boolean;
    protected markerFactory(): Marker;
    protected updatePathNodes(opts: {
        seriesHighlighted?: boolean;
        paths: Path[];
        opacity: number;
        visible: boolean;
        animationEnabled: boolean;
    }): void;
    protected updateMarkerSelection(opts: {
        nodeData: LineNodeDatum[];
        markerSelection: Selection<Marker, LineNodeDatum>;
        markerGroup?: Group;
    }): Selection<Marker, LineNodeDatum>;
    protected updateMarkerNodes(opts: {
        markerSelection: Selection<Marker, LineNodeDatum>;
        isHighlight: boolean;
    }): void;
    protected updateLabelSelection(opts: {
        labelData: LineNodeDatum[];
        labelSelection: Selection<Text, LineNodeDatum>;
    }): Selection<Text, LineNodeDatum>;
    protected updateLabelNodes(opts: {
        labelSelection: Selection<Text, LineNodeDatum>;
    }): void;
    getTooltipContent(nodeDatum: LineNodeDatum): TooltipContent | string | undefined;
    private legendItemSymbol;
    getLegendData(legendType: ChartLegendType): CategoryLegendDatum[];
    protected updatePaths(opts: {
        contextData: LineSeriesNodeDataContext;
        paths: Path[];
    }): void;
    private plotNodeDataPoints;
    private updateLinePaths;
    protected animateEmptyUpdateReady(animationData: LineAnimationData): void;
    protected animateReadyResize(animationData: LineAnimationData): void;
    protected animateWaitingUpdateReady(animationData: LineAnimationData): void;
    protected isLabelEnabled(): boolean;
    getBandScalePadding(): {
        inner: number;
        outer: number;
    };
    protected nodeFactory(): Group;
    getFormattedMarkerStyle(datum: LineNodeDatum): import("ag-charts-types").AgSeriesMarkerStyle & {
        size: number;
    };
    protected computeFocusBounds(opts: PickFocusInputs): BBox | undefined;
}
export {};
