import type { ModuleContext } from '../../../module/moduleContext';
import type { AnimationValue } from '../../../motion/animation';
import { ColorScale } from '../../../scale/colorScale';
import type { BBox } from '../../../scene/bbox';
import type { Group } from '../../../scene/group';
import type { Node } from '../../../scene/node';
import type { Point } from '../../../scene/point';
import type { Selection } from '../../../scene/selection';
import type { Path } from '../../../scene/shape/path';
import { StateMachine } from '../../../util/stateMachine';
import type { ChartAnimationPhase } from '../../chartAnimationPhase';
import type { ChartAxisDirection } from '../../chartAxisDirection';
import type { HighlightNodeDatum } from '../../interaction/highlightManager';
import type { ChartLegendType, GradientLegendDatum } from '../../legend/legendDatum';
import { type PickFocusInputs, type PickFocusOutputs, Series } from '../series';
import type { ISeries, SeriesNodeDatum } from '../seriesTypes';
import type { HierarchySeriesProperties } from './hierarchySeriesProperties';
type HierarchyAnimationState = 'empty' | 'ready' | 'waiting' | 'clearing';
type HierarchyAnimationEvent<TNode extends Node, TDatum> = {
    update: HierarchyAnimationData<TNode, TDatum>;
    updateData: undefined;
    highlight: Selection<TNode, HierarchyNode<TDatum>>;
    resize: HierarchyAnimationData<TNode, TDatum>;
    clear: HierarchyAnimationData<TNode, TDatum>;
    reset: undefined;
    skip: undefined;
};
export interface HierarchyAnimationData<TNode extends Node, TDatum> {
    datumSelections: Selection<TNode, HierarchyNode<TDatum>>[];
}
export declare class HierarchyNode<TDatum = Record<string, any>> implements SeriesNodeDatum, Pick<HighlightNodeDatum, 'colorValue'> {
    readonly series: ISeries<any, any>;
    readonly index: number;
    readonly rootIndex: number;
    readonly datum: TDatum | undefined;
    readonly sizeValue: number;
    readonly colorValue: number | undefined;
    readonly sumSize: number;
    readonly depth: number | undefined;
    readonly parent: HierarchyNode<TDatum> | undefined;
    readonly children: HierarchyNode<TDatum>[];
    private static readonly Walk;
    readonly midPoint: Point;
    constructor(series: ISeries<any, any>, index: number, rootIndex: number, datum: TDatum | undefined, sizeValue: number, colorValue: number | undefined, sumSize: number, depth: number | undefined, parent: HierarchyNode<TDatum> | undefined, children: HierarchyNode<TDatum>[]);
    contains(other: HierarchyNode<TDatum>): boolean;
    walk(callback: (node: HierarchyNode<TDatum>) => void, order?: number): void;
    [Symbol.iterator](): Iterator<HierarchyNode<TDatum>>;
}
type FocusPathNode<TDatum> = {
    nodeDatum: HierarchyNode<TDatum>;
    childIndex: number;
};
export declare abstract class HierarchySeries<TNode extends Node = Group, TProps extends HierarchySeriesProperties<any> = HierarchySeriesProperties<any>, TDatum extends SeriesNodeDatum = SeriesNodeDatum> extends Series<TDatum, TProps> {
    rootNode: HierarchyNode<TDatum>;
    colorDomain: number[];
    maxDepth: number;
    protected colorScale: ColorScale;
    protected animationState: StateMachine<HierarchyAnimationState, HierarchyAnimationEvent<TNode, TDatum>>;
    protected animationResetFns?: {
        datum?: (node: TNode, datum: HierarchyNode<TDatum>) => AnimationValue & Partial<TNode>;
    };
    constructor(moduleCtx: ModuleContext);
    resetAnimation(phase: ChartAnimationPhase): void;
    processData(): void;
    protected abstract updateSelections(): void;
    protected abstract updateNodes(): void;
    update({ seriesRect }: {
        seriesRect?: BBox;
    }): void;
    protected resetAllAnimation(data: HierarchyAnimationData<TNode, TDatum>): void;
    protected animateEmptyUpdateReady(data: HierarchyAnimationData<TNode, TDatum>): void;
    protected animateWaitingUpdateReady(data: HierarchyAnimationData<TNode, TDatum>): void;
    protected animateReadyHighlight(data: Selection<TNode, HierarchyNode<TDatum>>): void;
    protected animateReadyResize(data: HierarchyAnimationData<TNode, TDatum>): void;
    protected animateClearingUpdateEmpty(data: HierarchyAnimationData<TNode, TDatum>): void;
    protected abstract getAnimationData(): HierarchyAnimationData<TNode, TDatum>;
    protected isProcessedDataAnimatable(): boolean;
    protected checkProcessedDataAnimatable(): void;
    getSeriesDomain(): number[];
    getSeriesRange(_direction: ChartAxisDirection, _visibleRange: [any, any]): [number, number];
    getLegendData(legendType: ChartLegendType): GradientLegendDatum[];
    protected getDatumIdFromData(node: HierarchyNode): string;
    protected getDatumId(node: HierarchyNode): string;
    protected focusPath: FocusPathNode<TDatum>[];
    protected abstract computeFocusBounds(node: HierarchyNode<TDatum>): BBox | Path | undefined;
    pickFocus(opts: PickFocusInputs): PickFocusOutputs | undefined;
    getDatumAriaText(datum: SeriesNodeDatum, description: string): string | undefined;
    protected computeFocusOutputs({ nodeDatum, childIndex }: FocusPathNode<TDatum>): PickFocusOutputs | undefined;
}
export {};
