import type { AgChartLabelFormatterParams, AgChartLabelOptions, AgInitialStateLegendOptions, AgSeriesMarkerStyle, AgSeriesMarkerStylerParams, AgSeriesVisibilityChange, ISeriesMarker } from 'ag-charts-types';
import type { ModuleContext, SeriesContext } from '../../module/moduleContext';
import { ModuleMap } from '../../module/moduleMap';
import type { SeriesOptionInstance, SeriesOptionModule, SeriesType } from '../../module/optionsModuleTypes';
import type { BBox } from '../../scene/bbox';
import { Group, TranslatableGroup } from '../../scene/group';
import type { Node } from '../../scene/node';
import type { Point } from '../../scene/point';
import type { Path } from '../../scene/shape/path';
import type { PlacedLabel, PointLabelDatum } from '../../scene/util/labelPlacement';
import { LRUCache } from '../../util/lruCache';
import { type DistantObject } from '../../util/nearest';
import type { TypedEvent, TypedEventListener } from '../../util/observable';
import { Observable } from '../../util/observable';
import type { ChartAnimationPhase } from '../chartAnimationPhase';
import type { ChartAxis } from '../chartAxis';
import { ChartAxisDirection } from '../chartAxisDirection';
import type { ChartMode } from '../chartMode';
import type { DataController } from '../data/dataController';
import type { LegendItemClickChartEvent, LegendItemDoubleClickChartEvent } from '../interaction/chartEventManager';
import type { ChartLegendDatum, ChartLegendType } from '../legend/legendDatum';
import type { Marker } from '../marker/marker';
import type { TooltipContent } from '../tooltip/tooltip';
import type { SeriesEventType } from './seriesEvents';
import type { SeriesProperties } from './seriesProperties';
import type { SeriesGrouping } from './seriesStateManager';
import type { ISeries, NodeDataDependencies, SeriesNodeDatum } from './seriesTypes';
/** Modes of matching user interactions to rendered nodes (e.g. hover or click) */
export declare enum SeriesNodePickMode {
    /** Pick matches based upon pick coordinates being inside a matching shape/marker. */
    EXACT_SHAPE_MATCH = 0,
    /** Pick matches based upon distance to ideal position */
    NEAREST_NODE = 1,
    /** Pick matches based upon distance from axis */
    AXIS_ALIGNED = 2
}
export type SeriesNodePickIntent = 'tooltip' | 'highlight' | 'highlight-tooltip' | 'context-menu' | 'event';
export type SeriesNodePickMatch = {
    datum: SeriesNodeDatum;
    distance: number;
};
export type PickFocusInputs = {
    readonly datumIndex: number;
    readonly datumIndexDelta: number;
    readonly otherIndex: number;
    readonly otherIndexDelta: number;
    readonly seriesRect?: BBox;
};
export type PickFocusOutputs = {
    datumIndex: number;
    datum: SeriesNodeDatum;
    otherIndex?: number;
    bounds: BBox | Path;
    showFocusBox: boolean;
    clipFocusBox: boolean;
};
export type PickResult = {
    pickMode: SeriesNodePickMode;
    match: SeriesNodeDatum;
    distance: number;
};
export type SeriesNodeEventTypes = 'nodeClick' | 'nodeDoubleClick' | 'nodeContextMenuAction' | 'groupingChanged';
interface INodeEvent<TEvent extends string = SeriesNodeEventTypes> extends TypedEvent {
    readonly type: TEvent;
    readonly event: Event;
    readonly datum: unknown;
    readonly seriesId: string;
}
export type INodeEventConstructor<TDatum extends SeriesNodeDatum, TSeries extends Series<TDatum, any>, TEvent extends string = SeriesNodeEventTypes> = new <T extends TEvent>(type: T, event: Event, { datum }: TDatum, series: TSeries) => INodeEvent<T>;
export declare class SeriesNodeEvent<TDatum extends SeriesNodeDatum, TEvent extends string = SeriesNodeEventTypes> implements INodeEvent<TEvent> {
    readonly type: TEvent;
    readonly event: Event;
    readonly datum: unknown;
    readonly seriesId: string;
    constructor(type: TEvent, event: Event, { datum }: TDatum, series: ISeries<TDatum, unknown, unknown>);
}
export type SeriesNodeDataContext<S = SeriesNodeDatum, L = S> = {
    itemId: string;
    nodeData: S[];
    labelData: L[];
};
declare enum SeriesHighlight {
    None = 0,
    This = 1,
    Other = 2
}
export type SeriesModuleMap = ModuleMap<SeriesOptionModule, SeriesOptionInstance, SeriesContext>;
export type SeriesDirectionKeysMapping<P extends SeriesProperties<any>> = {
    [key in ChartAxisDirection]?: (keyof P & string)[];
};
export declare class SeriesGroupingChangedEvent implements TypedEvent {
    series: Series<any, any>;
    seriesGrouping: SeriesGrouping | undefined;
    oldGrouping: SeriesGrouping | undefined;
    type: string;
    constructor(series: Series<any, any>, seriesGrouping: SeriesGrouping | undefined, oldGrouping: SeriesGrouping | undefined);
}
export type SeriesConstructorOpts<TProps extends SeriesProperties<any>> = {
    moduleCtx: ModuleContext;
    useLabelLayer?: boolean;
    pickModes: SeriesNodePickMode[];
    directionKeys?: SeriesDirectionKeysMapping<TProps>;
    directionNames?: SeriesDirectionKeysMapping<TProps>;
    canHaveAxes?: boolean;
    usesPlacedLabels?: boolean;
};
export declare abstract class Series<TDatum extends SeriesNodeDatum, TProps extends SeriesProperties<any>, TLabel = TDatum, TContext extends SeriesNodeDataContext<TDatum, TLabel> = SeriesNodeDataContext<TDatum, TLabel>> extends Observable implements ISeries<TDatum, TProps, TLabel> {
    protected destroyFns: (() => void)[];
    abstract readonly properties: TProps;
    pickModes: SeriesNodePickMode[];
    usesPlacedLabels: boolean;
    get pickModeAxis(): 'main' | 'main-category' | undefined;
    seriesGrouping?: SeriesGrouping;
    protected static readonly highlightedZIndex = 1000000000000;
    protected readonly NodeEvent: INodeEventConstructor<TDatum, any>;
    readonly internalId: string;
    get id(): string;
    readonly canHaveAxes: boolean;
    get type(): SeriesType;
    readonly contentGroup: TranslatableGroup;
    readonly highlightGroup: TranslatableGroup;
    readonly annotationGroup: TranslatableGroup;
    readonly labelGroup: TranslatableGroup;
    readonly highlightNode: Group;
    readonly highlightLabel: Group;
    chart?: {
        mode: ChartMode;
        isMiniChart: boolean;
        seriesRect?: BBox;
    };
    axes: Record<ChartAxisDirection, ChartAxis | undefined>;
    directions: ChartAxisDirection[];
    private readonly directionKeys;
    private readonly directionNames;
    protected nodeDataRefresh: boolean;
    protected readonly moduleMap: SeriesModuleMap;
    protected _data?: any[];
    protected _chartData?: any[];
    private readonly datumCallbackCache;
    connectsToYAxis: boolean;
    get data(): any[] | undefined;
    set visible(newVisibility: boolean);
    get visible(): boolean;
    get hasData(): boolean;
    get tooltipEnabled(): boolean;
    protected onDataChange(): void;
    setOptionsData(input: unknown[]): void;
    setChartData(input: unknown[]): void;
    private onSeriesGroupingChange;
    getBandScalePadding(): {
        inner: number;
        outer: number;
    };
    protected readonly ctx: ModuleContext;
    constructor(seriesOpts: SeriesConstructorOpts<TProps>);
    attachSeries(seriesContentNode: Node, seriesNode: Node, annotationNode: Node | undefined): void;
    detachSeries(seriesContentNode: Node | undefined, seriesNode: Node, annotationNode: Node | undefined): void;
    _declarationOrder: number;
    setSeriesIndex(index: number): boolean;
    renderToOffscreenCanvas(): boolean;
    private readonly seriesListeners;
    addEventListener(type: 'seriesVisibilityChange', listener: (e: AgSeriesVisibilityChange) => void): void;
    addEventListener(type: string, listener: TypedEventListener): void;
    addListener<T extends SeriesEventType, E>(type: T, listener: (event: E) => void): () => void;
    protected dispatch<T extends SeriesEventType, E>(type: T, event: E): void;
    addChartEventListeners(): void;
    destroy(): void;
    abstract resetAnimation(chartAnimationPhase: ChartAnimationPhase): void;
    private getDirectionValues;
    getKeys(direction: ChartAxisDirection): string[];
    getKeyProperties(direction: ChartAxisDirection): (keyof TProps & string)[];
    getNames(direction: ChartAxisDirection): (string | undefined)[];
    protected resolveKeyDirection(direction: ChartAxisDirection): ChartAxisDirection;
    getDomain(direction: ChartAxisDirection): any[];
    getRange(direction: ChartAxisDirection, visibleRange: [number, number]): [number, number];
    abstract getSeriesDomain(direction: ChartAxisDirection): any[];
    abstract getSeriesRange(_direction: ChartAxisDirection, _visibleRange: [number, number]): [number, number];
    abstract processData(dataController: DataController): Promise<void> | void;
    abstract createNodeData(): TContext | undefined;
    markNodeDataDirty(): void;
    private visibleMaybeChanged;
    abstract update(opts: {
        seriesRect?: BBox;
    }): Promise<void> | void;
    getOpacity(): number;
    protected getStrokeWidth(defaultStrokeWidth: number): number;
    protected isItemIdHighlighted(): SeriesHighlight;
    protected getModuleTooltipParams(): object;
    abstract getTooltipContent(_seriesDatum: any): TooltipContent | string | undefined;
    protected _pickNodeCache: LRUCache<string, PickResult | undefined>;
    pickNode(point: Point, intent: SeriesNodePickIntent, exactMatchOnly?: boolean): PickResult | undefined;
    protected pickNodeExactShape(point: Point): SeriesNodePickMatch | undefined;
    protected pickNodeClosestDatum(_point: Point): SeriesNodePickMatch | undefined;
    protected pickNodeNearestDistantObject<T extends Node & DistantObject>(point: Point, items: Iterable<T>): {
        datum: any;
        distance: number;
    } | undefined;
    protected pickNodeMainAxisFirst(_point: Point, _requireCategoryAxis: boolean): SeriesNodePickMatch | undefined;
    getLabelData(): (TLabel & PointLabelDatum)[];
    updatePlacedLabelData(_labels: PlacedLabel<TLabel>[]): void;
    fireNodeClickEvent(event: Event, datum: TDatum): void;
    fireNodeDoubleClickEvent(event: Event, datum: TDatum): void;
    createNodeContextMenuActionEvent(event: Event, datum: TDatum): INodeEvent<'nodeContextMenuAction'>;
    onLegendInitialState(legendType: ChartLegendType, initialState: AgInitialStateLegendOptions | undefined): void;
    onLegendItemClick(event: LegendItemClickChartEvent): void;
    onLegendItemDoubleClick(event: LegendItemDoubleClickChartEvent): void;
    abstract getLegendData<T extends ChartLegendType>(legendType: T): ChartLegendDatum<T>[];
    abstract getLegendData(legendType: ChartLegendType): ChartLegendDatum<ChartLegendType>[];
    protected toggleSeriesItem(enabled: boolean, legendType: ChartLegendType, itemId: string | number | undefined, legendItemName: string | undefined, legendEvent?: {
        legendItemName?: string;
    }): void;
    isEnabled(): boolean;
    getModuleMap(): SeriesModuleMap;
    createModuleContext(): SeriesContext;
    protected getLabelText<TParams>(label: AgChartLabelOptions<any, TParams>, params: TParams & Omit<AgChartLabelFormatterParams<any>, 'seriesId'>, defaultFormatter?: (value: any) => string): string;
    getMarkerStyle<TParams>(marker: ISeriesMarker<TParams>, params: TParams & Omit<AgSeriesMarkerStylerParams<TDatum>, 'seriesId' | keyof AgSeriesMarkerStyle>, defaultStyle?: AgSeriesMarkerStyle): AgSeriesMarkerStyle & {
        size: number;
    };
    protected updateMarkerStyle<TParams>(markerNode: Marker, marker: ISeriesMarker<TParams>, params: TParams & Omit<AgSeriesMarkerStylerParams<TDatum>, 'seriesId'>, defaultStyle?: AgSeriesMarkerStyle, { applyTranslation, selected }?: {
        applyTranslation?: boolean | undefined;
        selected?: boolean | undefined;
    }): void;
    getMinRects(_width: number, _height: number): {
        minRect: BBox;
        minVisibleRect: BBox;
    } | undefined;
    protected _nodeDataDependencies?: NodeDataDependencies;
    get nodeDataDependencies(): NodeDataDependencies;
    protected checkResize(newSeriesRect?: BBox): boolean;
    pickFocus(_opts: PickFocusInputs): PickFocusOutputs | undefined;
    resetDatumCallbackCache(): void;
    cachedDatumCallback<T>(id: any, fn: () => T): T;
}
export {};
